// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLVIDEOELEMENT_VIDEOFRAME_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLVIDEOELEMENT_VIDEOFRAME_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLVideoElement;
class ScriptState;
class VideoFrame;

class MODULES_EXPORT V8UnionHTMLVideoElementOrVideoFrame final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kHTMLVideoElement, kVideoFrame
};

static V8UnionHTMLVideoElementOrVideoFrame* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionHTMLVideoElementOrVideoFrame(HTMLVideoElement* value) : content_type_(ContentType::kHTMLVideoElement), member_html_video_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLVideoElementOrVideoFrame(VideoFrame* value) : content_type_(ContentType::kVideoFrame), member_video_frame_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsHTMLVideoElement() const {
  return content_type_ == ContentType::kHTMLVideoElement;
}
HTMLVideoElement* GetAsHTMLVideoElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLVideoElement);
return member_html_video_element_.Get();
}
void Set(HTMLVideoElement* value) {
  DCHECK(value);
Clear();
member_html_video_element_ = value;
content_type_ = ContentType::kHTMLVideoElement;
}

bool IsVideoFrame() const {
  return content_type_ == ContentType::kVideoFrame;
}
VideoFrame* GetAsVideoFrame() const {
  DCHECK_EQ(content_type_, ContentType::kVideoFrame);
return member_video_frame_.Get();
}
void Set(VideoFrame* value) {
  DCHECK(value);
Clear();
member_video_frame_ = value;
content_type_ = ContentType::kVideoFrame;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(HTMLVideoElement or VideoFrame)";
}

ContentType content_type_;

Member<HTMLVideoElement> member_html_video_element_;
Member<VideoFrame> member_video_frame_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLVIDEOELEMENT_VIDEOFRAME_H_
