// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLCANVASELEMENT_HTMLIMAGEELEMENT_HTMLVIDEOELEMENT_IMAGEBITMAP_IMAGEDATA_OFFSCREENCANVAS_VIDEOFRAME_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLCANVASELEMENT_HTMLIMAGEELEMENT_HTMLVIDEOELEMENT_IMAGEBITMAP_IMAGEDATA_OFFSCREENCANVAS_VIDEOFRAME_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
class ImageData;
class OffscreenCanvas;
class ScriptState;
class V8UnionHTMLCanvasElementOrOffscreenCanvas;
class V8UnionHTMLVideoElementOrVideoFrame;
class VideoFrame;

class MODULES_EXPORT V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kHTMLCanvasElement, kHTMLImageElement, kHTMLVideoElement, kImageBitmap, kImageData, kOffscreenCanvas, kVideoFrame
};

static V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(HTMLCanvasElement* value) : content_type_(ContentType::kHTMLCanvasElement), member_html_canvas_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(HTMLImageElement* value) : content_type_(ContentType::kHTMLImageElement), member_html_image_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(HTMLVideoElement* value) : content_type_(ContentType::kHTMLVideoElement), member_html_video_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(ImageBitmap* value) : content_type_(ContentType::kImageBitmap), member_image_bitmap_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(ImageData* value) : content_type_(ContentType::kImageData), member_image_data_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(OffscreenCanvas* value) : content_type_(ContentType::kOffscreenCanvas), member_offscreen_canvas_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame(VideoFrame* value) : content_type_(ContentType::kVideoFrame), member_video_frame_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsHTMLCanvasElement() const {
  return content_type_ == ContentType::kHTMLCanvasElement;
}
HTMLCanvasElement* GetAsHTMLCanvasElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLCanvasElement);
return member_html_canvas_element_.Get();
}
void Set(HTMLCanvasElement* value) {
  DCHECK(value);
Clear();
member_html_canvas_element_ = value;
content_type_ = ContentType::kHTMLCanvasElement;
}

bool IsHTMLImageElement() const {
  return content_type_ == ContentType::kHTMLImageElement;
}
HTMLImageElement* GetAsHTMLImageElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLImageElement);
return member_html_image_element_.Get();
}
void Set(HTMLImageElement* value) {
  DCHECK(value);
Clear();
member_html_image_element_ = value;
content_type_ = ContentType::kHTMLImageElement;
}

bool IsHTMLVideoElement() const {
  return content_type_ == ContentType::kHTMLVideoElement;
}
HTMLVideoElement* GetAsHTMLVideoElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLVideoElement);
return member_html_video_element_.Get();
}
void Set(HTMLVideoElement* value) {
  DCHECK(value);
Clear();
member_html_video_element_ = value;
content_type_ = ContentType::kHTMLVideoElement;
}

bool IsImageBitmap() const {
  return content_type_ == ContentType::kImageBitmap;
}
ImageBitmap* GetAsImageBitmap() const {
  DCHECK_EQ(content_type_, ContentType::kImageBitmap);
return member_image_bitmap_.Get();
}
void Set(ImageBitmap* value) {
  DCHECK(value);
Clear();
member_image_bitmap_ = value;
content_type_ = ContentType::kImageBitmap;
}

bool IsImageData() const {
  return content_type_ == ContentType::kImageData;
}
ImageData* GetAsImageData() const {
  DCHECK_EQ(content_type_, ContentType::kImageData);
return member_image_data_.Get();
}
void Set(ImageData* value) {
  DCHECK(value);
Clear();
member_image_data_ = value;
content_type_ = ContentType::kImageData;
}

bool IsOffscreenCanvas() const {
  return content_type_ == ContentType::kOffscreenCanvas;
}
OffscreenCanvas* GetAsOffscreenCanvas() const {
  DCHECK_EQ(content_type_, ContentType::kOffscreenCanvas);
return member_offscreen_canvas_.Get();
}
void Set(OffscreenCanvas* value) {
  DCHECK(value);
Clear();
member_offscreen_canvas_ = value;
content_type_ = ContentType::kOffscreenCanvas;
}

bool IsVideoFrame() const {
  return content_type_ == ContentType::kVideoFrame;
}
VideoFrame* GetAsVideoFrame() const {
  DCHECK_EQ(content_type_, ContentType::kVideoFrame);
return member_video_frame_.Get();
}
void Set(VideoFrame* value) {
  DCHECK(value);
Clear();
member_video_frame_ = value;
content_type_ = ContentType::kVideoFrame;
}

bool IsV8UnionHTMLCanvasElementOrOffscreenCanvas() const {
  return content_type_ == ContentType::kHTMLCanvasElement || content_type_ == ContentType::kOffscreenCanvas;
}
V8UnionHTMLCanvasElementOrOffscreenCanvas* GetAsV8UnionHTMLCanvasElementOrOffscreenCanvas() const;
void Set(const V8UnionHTMLCanvasElementOrOffscreenCanvas* value);

bool IsV8UnionHTMLVideoElementOrVideoFrame() const {
  return content_type_ == ContentType::kHTMLVideoElement || content_type_ == ContentType::kVideoFrame;
}
V8UnionHTMLVideoElementOrVideoFrame* GetAsV8UnionHTMLVideoElementOrVideoFrame() const;
void Set(const V8UnionHTMLVideoElementOrVideoFrame* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(HTMLCanvasElement or HTMLImageElement or HTMLVideoElement or ImageBitmap or ImageData or OffscreenCanvas or VideoFrame)";
}

ContentType content_type_;

Member<HTMLCanvasElement> member_html_canvas_element_;
Member<HTMLImageElement> member_html_image_element_;
Member<HTMLVideoElement> member_html_video_element_;
Member<ImageBitmap> member_image_bitmap_;
Member<ImageData> member_image_data_;
Member<OffscreenCanvas> member_offscreen_canvas_;
Member<VideoFrame> member_video_frame_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLCANVASELEMENT_HTMLIMAGEELEMENT_HTMLVIDEOELEMENT_IMAGEBITMAP_IMAGEDATA_OFFSCREENCANVAS_VIDEOFRAME_H_
