// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUBUFFER_GPUBUFFERBINDING_GPUEXTERNALTEXTURE_GPUSAMPLER_GPUTEXTURE_GPUTEXTUREVIEW_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUBUFFER_GPUBUFFERBINDING_GPUEXTERNALTEXTURE_GPUSAMPLER_GPUTEXTURE_GPUTEXTUREVIEW_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBuffer;
class GPUBufferBinding;
class GPUExternalTexture;
class GPUSampler;
class GPUTexture;
class GPUTextureView;
class ScriptState;
class V8UnionGPUTextureOrGPUTextureView;

class MODULES_EXPORT V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kGPUBuffer, kGPUBufferBinding, kGPUExternalTexture, kGPUSampler, kGPUTexture, kGPUTextureView
};

static V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView(GPUBuffer* value) : content_type_(ContentType::kGPUBuffer), member_gpu_buffer_(value) {
  DCHECK(value);
}
explicit  V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView(GPUBufferBinding* value) : content_type_(ContentType::kGPUBufferBinding), member_gpu_buffer_binding_(value) {
  DCHECK(value);
}
explicit  V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView(GPUExternalTexture* value) : content_type_(ContentType::kGPUExternalTexture), member_gpu_external_texture_(value) {
  DCHECK(value);
}
explicit  V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView(GPUSampler* value) : content_type_(ContentType::kGPUSampler), member_gpu_sampler_(value) {
  DCHECK(value);
}
explicit  V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView(GPUTexture* value) : content_type_(ContentType::kGPUTexture), member_gpu_texture_(value) {
  DCHECK(value);
}
explicit  V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView(GPUTextureView* value) : content_type_(ContentType::kGPUTextureView), member_gpu_texture_view_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsGPUBuffer() const {
  return content_type_ == ContentType::kGPUBuffer;
}
GPUBuffer* GetAsGPUBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kGPUBuffer);
return member_gpu_buffer_.Get();
}
void Set(GPUBuffer* value) {
  DCHECK(value);
Clear();
member_gpu_buffer_ = value;
content_type_ = ContentType::kGPUBuffer;
}

bool IsGPUBufferBinding() const {
  return content_type_ == ContentType::kGPUBufferBinding;
}
GPUBufferBinding* GetAsGPUBufferBinding() const {
  DCHECK_EQ(content_type_, ContentType::kGPUBufferBinding);
return member_gpu_buffer_binding_.Get();
}
void Set(GPUBufferBinding* value) {
  DCHECK(value);
Clear();
member_gpu_buffer_binding_ = value;
content_type_ = ContentType::kGPUBufferBinding;
}

bool IsGPUExternalTexture() const {
  return content_type_ == ContentType::kGPUExternalTexture;
}
GPUExternalTexture* GetAsGPUExternalTexture() const {
  DCHECK_EQ(content_type_, ContentType::kGPUExternalTexture);
return member_gpu_external_texture_.Get();
}
void Set(GPUExternalTexture* value) {
  DCHECK(value);
Clear();
member_gpu_external_texture_ = value;
content_type_ = ContentType::kGPUExternalTexture;
}

bool IsGPUSampler() const {
  return content_type_ == ContentType::kGPUSampler;
}
GPUSampler* GetAsGPUSampler() const {
  DCHECK_EQ(content_type_, ContentType::kGPUSampler);
return member_gpu_sampler_.Get();
}
void Set(GPUSampler* value) {
  DCHECK(value);
Clear();
member_gpu_sampler_ = value;
content_type_ = ContentType::kGPUSampler;
}

bool IsGPUTexture() const {
  return content_type_ == ContentType::kGPUTexture;
}
GPUTexture* GetAsGPUTexture() const {
  DCHECK_EQ(content_type_, ContentType::kGPUTexture);
return member_gpu_texture_.Get();
}
void Set(GPUTexture* value) {
  DCHECK(value);
Clear();
member_gpu_texture_ = value;
content_type_ = ContentType::kGPUTexture;
}

bool IsGPUTextureView() const {
  return content_type_ == ContentType::kGPUTextureView;
}
GPUTextureView* GetAsGPUTextureView() const {
  DCHECK_EQ(content_type_, ContentType::kGPUTextureView);
return member_gpu_texture_view_.Get();
}
void Set(GPUTextureView* value) {
  DCHECK(value);
Clear();
member_gpu_texture_view_ = value;
content_type_ = ContentType::kGPUTextureView;
}

bool IsV8UnionGPUTextureOrGPUTextureView() const {
  return content_type_ == ContentType::kGPUTexture || content_type_ == ContentType::kGPUTextureView;
}
V8UnionGPUTextureOrGPUTextureView* GetAsV8UnionGPUTextureOrGPUTextureView() const;
void Set(const V8UnionGPUTextureOrGPUTextureView* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(GPUBuffer or GPUBufferBinding or GPUExternalTexture or GPUSampler or GPUTexture or GPUTextureView)";
}

ContentType content_type_;

Member<GPUBuffer> member_gpu_buffer_;
Member<GPUBufferBinding> member_gpu_buffer_binding_;
Member<GPUExternalTexture> member_gpu_external_texture_;
Member<GPUSampler> member_gpu_sampler_;
Member<GPUTexture> member_gpu_texture_;
Member<GPUTextureView> member_gpu_texture_view_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUBUFFER_GPUBUFFERBINDING_GPUEXTERNALTEXTURE_GPUSAMPLER_GPUTEXTURE_GPUTEXTUREVIEW_H_
