// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_DOMEXCEPTION_OVERCONSTRAINEDERROR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_DOMEXCEPTION_OVERCONSTRAINEDERROR_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMException;
class ExceptionState;
class OverconstrainedError;
class ScriptState;

class MODULES_EXPORT V8UnionDOMExceptionOrOverconstrainedError final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDOMException, kOverconstrainedError
};

static V8UnionDOMExceptionOrOverconstrainedError* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDOMExceptionOrOverconstrainedError(DOMException* value) : content_type_(ContentType::kDOMException), member_dom_exception_(value) {
  DCHECK(value);
}
explicit  V8UnionDOMExceptionOrOverconstrainedError(OverconstrainedError* value) : content_type_(ContentType::kOverconstrainedError), member_overconstrained_error_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDOMException() const {
  return content_type_ == ContentType::kDOMException;
}
DOMException* GetAsDOMException() const {
  DCHECK_EQ(content_type_, ContentType::kDOMException);
return member_dom_exception_.Get();
}
void Set(DOMException* value) {
  DCHECK(value);
Clear();
member_dom_exception_ = value;
content_type_ = ContentType::kDOMException;
}

bool IsOverconstrainedError() const {
  return content_type_ == ContentType::kOverconstrainedError;
}
OverconstrainedError* GetAsOverconstrainedError() const {
  DCHECK_EQ(content_type_, ContentType::kOverconstrainedError);
return member_overconstrained_error_.Get();
}
void Set(OverconstrainedError* value) {
  DCHECK(value);
Clear();
member_overconstrained_error_ = value;
content_type_ = ContentType::kOverconstrainedError;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMException or OverconstrainedError)";
}

ContentType content_type_;

Member<DOMException> member_dom_exception_;
Member<OverconstrainedError> member_overconstrained_error_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_DOMEXCEPTION_OVERCONSTRAINEDERROR_H_
