// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINDOUBLERANGE_DOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINDOUBLERANGE_DOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ConstrainDoubleRange;
class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionConstrainDoubleRangeOrDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kConstrainDoubleRange, kDouble
};

static V8UnionConstrainDoubleRangeOrDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionConstrainDoubleRangeOrDouble(ConstrainDoubleRange* value) : content_type_(ContentType::kConstrainDoubleRange), member_constrain_double_range_(value) {
  DCHECK(value);
}
explicit  V8UnionConstrainDoubleRangeOrDouble(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsConstrainDoubleRange() const {
  return content_type_ == ContentType::kConstrainDoubleRange;
}
ConstrainDoubleRange* GetAsConstrainDoubleRange() const {
  DCHECK_EQ(content_type_, ContentType::kConstrainDoubleRange);
return member_constrain_double_range_.Get();
}
void Set(ConstrainDoubleRange* value) {
  DCHECK(value);
Clear();
member_constrain_double_range_ = value;
content_type_ = ContentType::kConstrainDoubleRange;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ConstrainDoubleRange or double)";
}

ContentType content_type_;

Member<ConstrainDoubleRange> member_constrain_double_range_;
double member_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINDOUBLERANGE_DOUBLE_H_
