// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BOOLEAN_CONSTRAINDOUBLERANGE_DOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BOOLEAN_CONSTRAINDOUBLERANGE_DOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ConstrainDoubleRange;
class ExceptionState;
class ScriptState;
class V8UnionConstrainDoubleRangeOrDouble;

class MODULES_EXPORT V8UnionBooleanOrConstrainDoubleRangeOrDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kBoolean, kConstrainDoubleRange, kDouble
};

static V8UnionBooleanOrConstrainDoubleRangeOrDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionBooleanOrConstrainDoubleRangeOrDouble(bool value) : content_type_(ContentType::kBoolean), member_boolean_(value) {
  
}
explicit  V8UnionBooleanOrConstrainDoubleRangeOrDouble(ConstrainDoubleRange* value) : content_type_(ContentType::kConstrainDoubleRange), member_constrain_double_range_(value) {
  DCHECK(value);
}
explicit  V8UnionBooleanOrConstrainDoubleRangeOrDouble(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsBoolean() const {
  return content_type_ == ContentType::kBoolean;
}
bool GetAsBoolean() const {
  DCHECK_EQ(content_type_, ContentType::kBoolean);
return member_boolean_;
}
void Set(bool value) {
  Clear();
member_boolean_ = value;
content_type_ = ContentType::kBoolean;
}

bool IsConstrainDoubleRange() const {
  return content_type_ == ContentType::kConstrainDoubleRange;
}
ConstrainDoubleRange* GetAsConstrainDoubleRange() const {
  DCHECK_EQ(content_type_, ContentType::kConstrainDoubleRange);
return member_constrain_double_range_.Get();
}
void Set(ConstrainDoubleRange* value) {
  DCHECK(value);
Clear();
member_constrain_double_range_ = value;
content_type_ = ContentType::kConstrainDoubleRange;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}

bool IsV8UnionConstrainDoubleRangeOrDouble() const {
  return content_type_ == ContentType::kConstrainDoubleRange || content_type_ == ContentType::kDouble;
}
V8UnionConstrainDoubleRangeOrDouble* GetAsV8UnionConstrainDoubleRangeOrDouble() const;
void Set(const V8UnionConstrainDoubleRangeOrDouble* value);
bool IsV8ConstrainDouble() const {
  return IsV8UnionConstrainDoubleRangeOrDouble();
}
V8UnionConstrainDoubleRangeOrDouble* GetAsV8ConstrainDouble() const {
  return GetAsV8UnionConstrainDoubleRangeOrDouble();
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ConstrainDoubleRange or boolean or double)";
}

ContentType content_type_;

bool member_boolean_;
Member<ConstrainDoubleRange> member_constrain_double_range_;
double member_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BOOLEAN_CONSTRAINDOUBLERANGE_DOUBLE_H_
