// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUCTIONAD_LONGLONG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUCTIONAD_LONGLONG_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AuctionAd;
class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionAuctionAdOrLongLong final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAuctionAd, kLongLong
};

static V8UnionAuctionAdOrLongLong* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAuctionAdOrLongLong(AuctionAd* value) : content_type_(ContentType::kAuctionAd), member_auction_ad_(value) {
  DCHECK(value);
}
explicit  V8UnionAuctionAdOrLongLong(int64_t value) : content_type_(ContentType::kLongLong), member_long_long_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAuctionAd() const {
  return content_type_ == ContentType::kAuctionAd;
}
AuctionAd* GetAsAuctionAd() const {
  DCHECK_EQ(content_type_, ContentType::kAuctionAd);
return member_auction_ad_.Get();
}
void Set(AuctionAd* value) {
  DCHECK(value);
Clear();
member_auction_ad_ = value;
content_type_ = ContentType::kAuctionAd;
}

bool IsLongLong() const {
  return content_type_ == ContentType::kLongLong;
}
int64_t GetAsLongLong() const {
  DCHECK_EQ(content_type_, ContentType::kLongLong);
return member_long_long_;
}
void Set(int64_t value) {
  Clear();
member_long_long_ = value;
content_type_ = ContentType::kLongLong;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AuctionAd or long long)";
}

ContentType content_type_;

Member<AuctionAd> member_auction_ad_;
int64_t member_long_long_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUCTIONAD_LONGLONG_H_
