// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ARRAYBUFFER_GPUBUFFER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ARRAYBUFFER_GPUBUFFER_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBuffer;
class ScriptState;

class MODULES_EXPORT V8UnionArrayBufferOrGPUBuffer final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kArrayBuffer, kGPUBuffer
};

static V8UnionArrayBufferOrGPUBuffer* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionArrayBufferOrGPUBuffer(DOMArrayBuffer* value) : content_type_(ContentType::kArrayBuffer), member_array_buffer_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrGPUBuffer(GPUBuffer* value) : content_type_(ContentType::kGPUBuffer), member_gpu_buffer_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsArrayBuffer() const {
  return content_type_ == ContentType::kArrayBuffer;
}
DOMArrayBuffer* GetAsArrayBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBuffer);
return member_array_buffer_.Get();
}
void Set(DOMArrayBuffer* value) {
  DCHECK(value);
Clear();
member_array_buffer_ = value;
content_type_ = ContentType::kArrayBuffer;
}

bool IsGPUBuffer() const {
  return content_type_ == ContentType::kGPUBuffer;
}
GPUBuffer* GetAsGPUBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kGPUBuffer);
return member_gpu_buffer_.Get();
}
void Set(GPUBuffer* value) {
  DCHECK(value);
Clear();
member_gpu_buffer_ = value;
content_type_ = ContentType::kGPUBuffer;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ArrayBuffer or GPUBuffer)";
}

ContentType content_type_;

Member<DOMArrayBuffer> member_array_buffer_;
Member<GPUBuffer> member_gpu_buffer_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ARRAYBUFFER_GPUBUFFER_H_
