// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_NDEFMESSAGEINIT_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_NDEFMESSAGEINIT_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class NDEFMessageInit;
class ScriptState;
class V8UnionArrayBufferOrArrayBufferView;
class V8UnionArrayBufferOrArrayBufferViewOrString;
class V8UnionArrayBufferOrString;

class MODULES_EXPORT V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kArrayBuffer, kArrayBufferView, kNDEFMessageInit, kString
};

static V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString(DOMArrayBuffer* value) : content_type_(ContentType::kArrayBuffer), member_array_buffer_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString(NotShared<DOMArrayBufferView> value) : content_type_(ContentType::kArrayBufferView), member_array_buffer_view_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString(NDEFMessageInit* value) : content_type_(ContentType::kNDEFMessageInit), member_ndef_message_init_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString(const String& value);
explicit  V8UnionArrayBufferOrArrayBufferViewOrNDEFMessageInitOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsArrayBuffer() const {
  return content_type_ == ContentType::kArrayBuffer;
}
DOMArrayBuffer* GetAsArrayBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBuffer);
return member_array_buffer_.Get();
}
void Set(DOMArrayBuffer* value) {
  DCHECK(value);
Clear();
member_array_buffer_ = value;
content_type_ = ContentType::kArrayBuffer;
}

bool IsArrayBufferView() const {
  return content_type_ == ContentType::kArrayBufferView;
}
NotShared<DOMArrayBufferView> GetAsArrayBufferView() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBufferView);
return member_array_buffer_view_;
}
void Set(NotShared<DOMArrayBufferView> value) {
  DCHECK(value);
Clear();
member_array_buffer_view_ = value;
content_type_ = ContentType::kArrayBufferView;
}

bool IsNDEFMessageInit() const {
  return content_type_ == ContentType::kNDEFMessageInit;
}
NDEFMessageInit* GetAsNDEFMessageInit() const {
  DCHECK_EQ(content_type_, ContentType::kNDEFMessageInit);
return member_ndef_message_init_.Get();
}
void Set(NDEFMessageInit* value) {
  DCHECK(value);
Clear();
member_ndef_message_init_ = value;
content_type_ = ContentType::kNDEFMessageInit;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionArrayBufferOrArrayBufferView() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView;
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8UnionArrayBufferOrArrayBufferView() const;
void Set(const V8UnionArrayBufferOrArrayBufferView* value);
bool IsV8BinaryData() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BinaryData() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}
bool IsV8BufferSource() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BufferSource() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}

bool IsV8UnionArrayBufferOrArrayBufferViewOrString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView || content_type_ == ContentType::kString;
}
V8UnionArrayBufferOrArrayBufferViewOrString* GetAsV8UnionArrayBufferOrArrayBufferViewOrString() const;
void Set(const V8UnionArrayBufferOrArrayBufferViewOrString* value);

bool IsV8UnionArrayBufferOrString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kString;
}
V8UnionArrayBufferOrString* GetAsV8UnionArrayBufferOrString() const;
void Set(const V8UnionArrayBufferOrString* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ArrayBuffer or ArrayBufferView or DOMString or NDEFMessageInit)";
}

ContentType content_type_;

Member<DOMArrayBuffer> member_array_buffer_;
NotShared<DOMArrayBufferView> member_array_buffer_view_;
Member<NDEFMessageInit> member_ndef_message_init_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_NDEFMESSAGEINIT_STRING_H_
