// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_udp_message.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"data",
"dnsQueryType",
"remoteAddress",
"remotePort",
};


}  // namespace 

UDPMessage* UDPMessage::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  UDPMessage* dictionary = MakeGarbageCollected<UDPMessage>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "UDPMessage";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 UDPMessage::UDPMessage() {
  
}

 UDPMessage::UDPMessage(v8::Isolate* isolate) {
  
}

















String UDPMessage::getRemoteAddressOr(const String& fallback_value) const {
  if (!hasRemoteAddress()) {
  return fallback_value;
}
return member_remote_address_;
}

String UDPMessage::getRemoteAddressOr(String&& fallback_value) const {
  if (!hasRemoteAddress()) {
  return std::move(fallback_value);
}
return member_remote_address_;
}

void UDPMessage::setRemoteAddress(const String& value) {
  member_remote_address_ = value;
has_remote_address_ = true;
}

void UDPMessage::setRemoteAddress(String&& value) {
  member_remote_address_ = std::move(value);
has_remote_address_ = true;
}










void UDPMessage::Trace(Visitor* visitor) const {
  visitor->Trace(member_data_);
bindings::DictionaryBase::Trace(visitor);
}

void UDPMessage::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void UDPMessage::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasData()) {
  values[0] = ToV8Traits<V8UnionArrayBufferOrArrayBufferView>::ToV8(script_state, member_data_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasDnsQueryType()) {
  values[1] = ToV8Traits<V8SocketDnsQueryType>::ToV8(script_state, member_dns_query_type_);
DCHECK(!values[1].IsEmpty());
}
if (hasRemoteAddress()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_remote_address_);
DCHECK(!values[2].IsEmpty());
}
if (hasRemotePort()) {
  values[3] = ToV8Traits<IDLUnsignedShort>::ToV8(script_state, member_remote_port_);
DCHECK(!values[3].IsEmpty());
}
}

const void* UDPMessage::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> UDPMessage::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void UDPMessage::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "UDPMessage";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("data");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferOrArrayBufferView, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_data_, member_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dnsQueryType");
if (!bindings::GetDictionaryMemberFromV8Object<V8SocketDnsQueryType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_dns_query_type_, member_dns_query_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteAddress");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_remote_address_, member_remote_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remotePort");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_remote_port_, member_remote_port_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> UDPMessage::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
