// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TCP_SOCKET_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TCP_SOCKET_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_socket_dns_query_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_socket_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT TCPSocketOptions : public SocketOptions {
  
  public:
static TCPSocketOptions* Create() {
  return MakeGarbageCollected<TCPSocketOptions>();
}
static TCPSocketOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TCPSocketOptions>(isolate);
}
static TCPSocketOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TCPSocketOptions();
explicit  TCPSocketOptions(v8::Isolate* isolate);

bool hasDnsQueryType() const {
  return has_dns_query_type_;
}
V8SocketDnsQueryType dnsQueryType() const {
  DCHECK(hasDnsQueryType());
return member_dns_query_type_;
}
V8SocketDnsQueryType getDnsQueryTypeOr(V8SocketDnsQueryType fallback_value) const {
  if (!hasDnsQueryType()) {
  return fallback_value;
}
return member_dns_query_type_;
}
void setDnsQueryType(V8SocketDnsQueryType value) {
  member_dns_query_type_ = value;
has_dns_query_type_ = true;
}
void setDnsQueryType(V8SocketDnsQueryType::Enum value) {
  member_dns_query_type_ = V8SocketDnsQueryType(value);
has_dns_query_type_ = true;
}

bool hasKeepAliveDelay() const {
  return has_keep_alive_delay_;
}
uint32_t keepAliveDelay() const {
  DCHECK(hasKeepAliveDelay());
return member_keep_alive_delay_;
}
uint32_t getKeepAliveDelayOr(uint32_t fallback_value) const {
  if (!hasKeepAliveDelay()) {
  return fallback_value;
}
return member_keep_alive_delay_;
}
void setKeepAliveDelay(uint32_t value) {
  member_keep_alive_delay_ = value;
has_keep_alive_delay_ = true;
}

bool hasNoDelay() const {
  return true;
}
bool noDelay() const {
  return member_no_delay_;
}
void setNoDelay(bool value) {
  member_no_delay_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = SocketOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dns_query_type_ = false;
bool has_keep_alive_delay_ = false;

V8SocketDnsQueryType member_dns_query_type_{static_cast<V8SocketDnsQueryType::Enum>(0)};
uint32_t member_keep_alive_delay_;
bool member_no_delay_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TCP_SOCKET_OPTIONS_H_
