// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TCP_SERVER_SOCKET_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TCP_SERVER_SOCKET_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT TCPServerSocketOptions : public bindings::InputDictionaryBase {
  
  public:
static TCPServerSocketOptions* Create() {
  return MakeGarbageCollected<TCPServerSocketOptions>();
}
static TCPServerSocketOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TCPServerSocketOptions>(isolate);
}
static TCPServerSocketOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TCPServerSocketOptions();
explicit  TCPServerSocketOptions(v8::Isolate* isolate);

bool hasBacklog() const {
  return has_backlog_;
}
uint32_t backlog() const {
  DCHECK(hasBacklog());
return member_backlog_;
}
uint32_t getBacklogOr(uint32_t fallback_value) const {
  if (!hasBacklog()) {
  return fallback_value;
}
return member_backlog_;
}
void setBacklog(uint32_t value) {
  member_backlog_ = value;
has_backlog_ = true;
}

bool hasIpv6Only() const {
  return has_ipv_6_only_;
}
bool ipv6Only() const {
  DCHECK(hasIpv6Only());
return member_ipv_6_only_;
}
bool getIpv6OnlyOr(bool fallback_value) const {
  if (!hasIpv6Only()) {
  return fallback_value;
}
return member_ipv_6_only_;
}
void setIpv6Only(bool value) {
  member_ipv_6_only_ = value;
has_ipv_6_only_ = true;
}

bool hasLocalPort() const {
  return has_local_port_;
}
uint16_t localPort() const {
  DCHECK(hasLocalPort());
return member_local_port_;
}
uint16_t getLocalPortOr(uint16_t fallback_value) const {
  if (!hasLocalPort()) {
  return fallback_value;
}
return member_local_port_;
}
void setLocalPort(uint16_t value) {
  member_local_port_ = value;
has_local_port_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_backlog_ = false;
bool has_ipv_6_only_ = false;
bool has_local_port_ = false;

uint32_t member_backlog_;
bool member_ipv_6_only_;
uint16_t member_local_port_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_TCP_SERVER_SOCKET_OPTIONS_H_
