// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUMMARIZER_SUMMARIZE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUMMARIZER_SUMMARIZE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AbortSignal;
class ExceptionState;

class MODULES_EXPORT SummarizerSummarizeOptions : public bindings::InputDictionaryBase {
  
  public:
static SummarizerSummarizeOptions* Create() {
  return MakeGarbageCollected<SummarizerSummarizeOptions>();
}
static SummarizerSummarizeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SummarizerSummarizeOptions>(isolate);
}
static SummarizerSummarizeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SummarizerSummarizeOptions();
explicit  SummarizerSummarizeOptions(v8::Isolate* isolate);

bool hasContext() const {
  return has_context_;
}
const String& context() const {
  DCHECK(hasContext());
return member_context_;
}
String getContextOr(const String& fallback_value) const;
String getContextOr(String&& fallback_value) const;
void setContext(const String& value);
void setContext(String&& value);

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_context_ = false;
bool has_signal_ = false;

String member_context_;
Member<AbortSignal> member_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SUMMARIZER_SUMMARIZE_OPTIONS_H_
