// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_TRANSMIT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_TRANSMIT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_protocol.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SmartCardTransmitOptions : public bindings::InputDictionaryBase {
  
  public:
static SmartCardTransmitOptions* Create() {
  return MakeGarbageCollected<SmartCardTransmitOptions>();
}
static SmartCardTransmitOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SmartCardTransmitOptions>(isolate);
}
static SmartCardTransmitOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SmartCardTransmitOptions();
explicit  SmartCardTransmitOptions(v8::Isolate* isolate);

bool hasProtocol() const {
  return has_protocol_;
}
V8SmartCardProtocol protocol() const {
  DCHECK(hasProtocol());
return member_protocol_;
}
V8SmartCardProtocol getProtocolOr(V8SmartCardProtocol fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_;
}
void setProtocol(V8SmartCardProtocol value) {
  member_protocol_ = value;
has_protocol_ = true;
}
void setProtocol(V8SmartCardProtocol::Enum value) {
  member_protocol_ = V8SmartCardProtocol(value);
has_protocol_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_protocol_ = false;

V8SmartCardProtocol member_protocol_{static_cast<V8SmartCardProtocol::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_TRANSMIT_OPTIONS_H_
