// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_PRIVATE_AGGREGATION_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_PRIVATE_AGGREGATION_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SharedStoragePrivateAggregationConfig : public bindings::InputDictionaryBase {
  
  public:
static SharedStoragePrivateAggregationConfig* Create() {
  return MakeGarbageCollected<SharedStoragePrivateAggregationConfig>();
}
static SharedStoragePrivateAggregationConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SharedStoragePrivateAggregationConfig>(isolate);
}
static SharedStoragePrivateAggregationConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SharedStoragePrivateAggregationConfig();
explicit  SharedStoragePrivateAggregationConfig(v8::Isolate* isolate);

bool hasAggregationCoordinatorOrigin() const {
  return has_aggregation_coordinator_origin_;
}
const String& aggregationCoordinatorOrigin() const {
  DCHECK(hasAggregationCoordinatorOrigin());
return member_aggregation_coordinator_origin_;
}
String getAggregationCoordinatorOriginOr(const String& fallback_value) const;
String getAggregationCoordinatorOriginOr(String&& fallback_value) const;
void setAggregationCoordinatorOrigin(const String& value);
void setAggregationCoordinatorOrigin(String&& value);

bool hasContextId() const {
  return has_context_id_;
}
const String& contextId() const {
  DCHECK(hasContextId());
return member_context_id_;
}
String getContextIdOr(const String& fallback_value) const;
String getContextIdOr(String&& fallback_value) const;
void setContextId(const String& value);
void setContextId(String&& value);

bool hasFilteringIdMaxBytes() const {
  return has_filtering_id_max_bytes_;
}
uint64_t filteringIdMaxBytes() const {
  DCHECK(hasFilteringIdMaxBytes());
return member_filtering_id_max_bytes_;
}
uint64_t getFilteringIdMaxBytesOr(uint64_t fallback_value) const {
  if (!hasFilteringIdMaxBytes()) {
  return fallback_value;
}
return member_filtering_id_max_bytes_;
}
void setFilteringIdMaxBytes(uint64_t value) {
  member_filtering_id_max_bytes_ = value;
has_filtering_id_max_bytes_ = true;
}

bool hasMaxContributions() const {
  return has_max_contributions_;
}
uint64_t maxContributions() const {
  DCHECK(hasMaxContributions());
return member_max_contributions_;
}
uint64_t getMaxContributionsOr(uint64_t fallback_value) const {
  if (!hasMaxContributions()) {
  return fallback_value;
}
return member_max_contributions_;
}
void setMaxContributions(uint64_t value) {
  member_max_contributions_ = value;
has_max_contributions_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_aggregation_coordinator_origin_ = false;
bool has_context_id_ = false;
bool has_filtering_id_max_bytes_ = false;
bool has_max_contributions_ = false;

String member_aggregation_coordinator_origin_;
String member_context_id_;
uint64_t member_filtering_id_max_bytes_;
uint64_t member_max_contributions_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARED_STORAGE_PRIVATE_AGGREGATION_CONFIG_H_
