// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_serial_port_request_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_unsignedlong.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_serial_port_filter.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"allowedBluetoothServiceClassIds",
"filters",
};


}  // namespace 

SerialPortRequestOptions* SerialPortRequestOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SerialPortRequestOptions* dictionary = MakeGarbageCollected<SerialPortRequestOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SerialPortRequestOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SerialPortRequestOptions::SerialPortRequestOptions() {
  
}

 SerialPortRequestOptions::SerialPortRequestOptions(v8::Isolate* isolate) {
  
}



HeapVector<Member<V8UnionStringOrUnsignedLong>> SerialPortRequestOptions::getAllowedBluetoothServiceClassIdsOr(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& fallback_value) const {
  if (!hasAllowedBluetoothServiceClassIds()) {
  return fallback_value;
}
return member_allowed_bluetooth_service_class_ids_;
}

HeapVector<Member<V8UnionStringOrUnsignedLong>> SerialPortRequestOptions::getAllowedBluetoothServiceClassIdsOr(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& fallback_value) const {
  if (!hasAllowedBluetoothServiceClassIds()) {
  return std::move(fallback_value);
}
return member_allowed_bluetooth_service_class_ids_;
}

void SerialPortRequestOptions::setAllowedBluetoothServiceClassIds(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value) {
  member_allowed_bluetooth_service_class_ids_ = value;
has_allowed_bluetooth_service_class_ids_ = true;
}

void SerialPortRequestOptions::setAllowedBluetoothServiceClassIds(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value) {
  member_allowed_bluetooth_service_class_ids_ = std::move(value);
has_allowed_bluetooth_service_class_ids_ = true;
}




HeapVector<Member<SerialPortFilter>> SerialPortRequestOptions::getFiltersOr(const HeapVector<Member<SerialPortFilter>>& fallback_value) const {
  if (!hasFilters()) {
  return fallback_value;
}
return member_filters_;
}

HeapVector<Member<SerialPortFilter>> SerialPortRequestOptions::getFiltersOr(HeapVector<Member<SerialPortFilter>>&& fallback_value) const {
  if (!hasFilters()) {
  return std::move(fallback_value);
}
return member_filters_;
}

void SerialPortRequestOptions::setFilters(const HeapVector<Member<SerialPortFilter>>& value) {
  member_filters_ = value;
has_filters_ = true;
}

void SerialPortRequestOptions::setFilters(HeapVector<Member<SerialPortFilter>>&& value) {
  member_filters_ = std::move(value);
has_filters_ = true;
}



void SerialPortRequestOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_allowed_bluetooth_service_class_ids_);
visitor->Trace(member_filters_);
bindings::InputDictionaryBase::Trace(visitor);
}

void SerialPortRequestOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SerialPortRequestOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("allowedBluetoothServiceClassIds");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionStringOrUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_allowed_bluetooth_service_class_ids_, member_allowed_bluetooth_service_class_ids_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("filters");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<SerialPortFilter>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_filters_, member_filters_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SerialPortRequestOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
