// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_FRAME_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_FRAME_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCEncodedFrameMetadata : public bindings::DictionaryBase {
  
  public:
static RTCEncodedFrameMetadata* Create() {
  return MakeGarbageCollected<RTCEncodedFrameMetadata>();
}
static RTCEncodedFrameMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCEncodedFrameMetadata>(isolate);
}
static RTCEncodedFrameMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCEncodedFrameMetadata();
explicit  RTCEncodedFrameMetadata(v8::Isolate* isolate);

bool hasCaptureTime() const {
  return has_capture_time_;
}
double captureTime() const {
  DCHECK(hasCaptureTime());
return member_capture_time_;
}
double getCaptureTimeOr(double fallback_value) const {
  if (!hasCaptureTime()) {
  return fallback_value;
}
return member_capture_time_;
}
void setCaptureTime(double value) {
  member_capture_time_ = value;
has_capture_time_ = true;
}

bool hasContributingSources() const {
  return has_contributing_sources_;
}
const Vector<uint32_t>& contributingSources() const {
  DCHECK(hasContributingSources());
return member_contributing_sources_;
}
Vector<uint32_t> getContributingSourcesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getContributingSourcesOr(Vector<uint32_t>&& fallback_value) const;
void setContributingSources(const Vector<uint32_t>& value);
void setContributingSources(Vector<uint32_t>&& value);

bool hasMimeType() const {
  return has_mime_type_;
}
const String& mimeType() const {
  DCHECK(hasMimeType());
return member_mime_type_;
}
String getMimeTypeOr(const String& fallback_value) const;
String getMimeTypeOr(String&& fallback_value) const;
void setMimeType(const String& value);
void setMimeType(String&& value);

bool hasPayloadType() const {
  return has_payload_type_;
}
uint8_t payloadType() const {
  DCHECK(hasPayloadType());
return member_payload_type_;
}
uint8_t getPayloadTypeOr(uint8_t fallback_value) const {
  if (!hasPayloadType()) {
  return fallback_value;
}
return member_payload_type_;
}
void setPayloadType(uint8_t value) {
  member_payload_type_ = value;
has_payload_type_ = true;
}

bool hasReceiveTime() const {
  return has_receive_time_;
}
double receiveTime() const {
  DCHECK(hasReceiveTime());
return member_receive_time_;
}
double getReceiveTimeOr(double fallback_value) const {
  if (!hasReceiveTime()) {
  return fallback_value;
}
return member_receive_time_;
}
void setReceiveTime(double value) {
  member_receive_time_ = value;
has_receive_time_ = true;
}

bool hasRtpTimestamp() const {
  return has_rtp_timestamp_;
}
uint32_t rtpTimestamp() const {
  DCHECK(hasRtpTimestamp());
return member_rtp_timestamp_;
}
uint32_t getRtpTimestampOr(uint32_t fallback_value) const {
  if (!hasRtpTimestamp()) {
  return fallback_value;
}
return member_rtp_timestamp_;
}
void setRtpTimestamp(uint32_t value) {
  member_rtp_timestamp_ = value;
has_rtp_timestamp_ = true;
}

bool hasSenderCaptureTimeOffset() const {
  return has_sender_capture_time_offset_;
}
double senderCaptureTimeOffset() const {
  DCHECK(hasSenderCaptureTimeOffset());
return member_sender_capture_time_offset_;
}
double getSenderCaptureTimeOffsetOr(double fallback_value) const {
  if (!hasSenderCaptureTimeOffset()) {
  return fallback_value;
}
return member_sender_capture_time_offset_;
}
void setSenderCaptureTimeOffset(double value) {
  member_sender_capture_time_offset_ = value;
has_sender_capture_time_offset_ = true;
}

bool hasSynchronizationSource() const {
  return has_synchronization_source_;
}
uint32_t synchronizationSource() const {
  DCHECK(hasSynchronizationSource());
return member_synchronization_source_;
}
uint32_t getSynchronizationSourceOr(uint32_t fallback_value) const {
  if (!hasSynchronizationSource()) {
  return fallback_value;
}
return member_synchronization_source_;
}
void setSynchronizationSource(uint32_t value) {
  member_synchronization_source_ = value;
has_synchronization_source_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_capture_time_ = false;
bool has_contributing_sources_ = false;
bool has_mime_type_ = false;
bool has_payload_type_ = false;
bool has_receive_time_ = false;
bool has_rtp_timestamp_ = false;
bool has_sender_capture_time_offset_ = false;
bool has_synchronization_source_ = false;

double member_capture_time_;
Vector<uint32_t> member_contributing_sources_;
String member_mime_type_;
uint8_t member_payload_type_;
double member_receive_time_;
uint32_t member_rtp_timestamp_;
double member_sender_capture_time_offset_;
uint32_t member_synchronization_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_FRAME_METADATA_H_
