// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_AUDIO_FRAME_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_AUDIO_FRAME_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_frame_metadata.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCEncodedAudioFrameMetadata : public RTCEncodedFrameMetadata {
  
  public:
static RTCEncodedAudioFrameMetadata* Create() {
  return MakeGarbageCollected<RTCEncodedAudioFrameMetadata>();
}
static RTCEncodedAudioFrameMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCEncodedAudioFrameMetadata>(isolate);
}
static RTCEncodedAudioFrameMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCEncodedAudioFrameMetadata();
explicit  RTCEncodedAudioFrameMetadata(v8::Isolate* isolate);

bool hasAudioLevel() const {
  return has_audio_level_;
}
double audioLevel() const {
  DCHECK(hasAudioLevel());
return member_audio_level_;
}
double getAudioLevelOr(double fallback_value) const {
  if (!hasAudioLevel()) {
  return fallback_value;
}
return member_audio_level_;
}
void setAudioLevel(double value) {
  member_audio_level_ = value;
has_audio_level_ = true;
}

bool hasSequenceNumber() const {
  return has_sequence_number_;
}
uint16_t sequenceNumber() const {
  DCHECK(hasSequenceNumber());
return member_sequence_number_;
}
uint16_t getSequenceNumberOr(uint16_t fallback_value) const {
  if (!hasSequenceNumber()) {
  return fallback_value;
}
return member_sequence_number_;
}
void setSequenceNumber(uint16_t value) {
  member_sequence_number_ = value;
has_sequence_number_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCEncodedFrameMetadata::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_level_ = false;
bool has_sequence_number_ = false;

double member_audio_level_;
uint16_t member_sequence_number_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_AUDIO_FRAME_METADATA_H_
