// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DTLS_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DTLS_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_ssl_role.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RtcDtlsParameters : public bindings::InputDictionaryBase {
  
  public:
static RtcDtlsParameters* Create() {
  return MakeGarbageCollected<RtcDtlsParameters>();
}
static RtcDtlsParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RtcDtlsParameters>(isolate);
}
static RtcDtlsParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RtcDtlsParameters();
explicit  RtcDtlsParameters(v8::Isolate* isolate);

bool hasFingerprint() const {
  return has_fingerprint_;
}
DOMArrayBuffer* fingerprint() const {
  DCHECK(hasFingerprint());
return member_fingerprint_.Get();
}
DOMArrayBuffer* getFingerprintOr(DOMArrayBuffer* fallback_value) const {
  if (!hasFingerprint()) {
  return fallback_value;
}
return member_fingerprint_.Get();
}
void setFingerprint(DOMArrayBuffer* value) {
  member_fingerprint_ = value;
has_fingerprint_ = true;
DCHECK(member_fingerprint_);
}

bool hasFingerprintDigestAlgorithm() const {
  return has_fingerprint_digest_algorithm_;
}
const String& fingerprintDigestAlgorithm() const {
  DCHECK(hasFingerprintDigestAlgorithm());
return member_fingerprint_digest_algorithm_;
}
String getFingerprintDigestAlgorithmOr(const String& fallback_value) const;
String getFingerprintDigestAlgorithmOr(String&& fallback_value) const;
void setFingerprintDigestAlgorithm(const String& value);
void setFingerprintDigestAlgorithm(String&& value);

bool hasSslRole() const {
  return has_ssl_role_;
}
V8RtcTransportSslRole sslRole() const {
  DCHECK(hasSslRole());
return member_ssl_role_;
}
V8RtcTransportSslRole getSslRoleOr(V8RtcTransportSslRole fallback_value) const {
  if (!hasSslRole()) {
  return fallback_value;
}
return member_ssl_role_;
}
void setSslRole(V8RtcTransportSslRole value) {
  member_ssl_role_ = value;
has_ssl_role_ = true;
}
void setSslRole(V8RtcTransportSslRole::Enum value) {
  member_ssl_role_ = V8RtcTransportSslRole(value);
has_ssl_role_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_fingerprint_ = false;
bool has_fingerprint_digest_algorithm_ = false;
bool has_ssl_role_ = false;

Member<DOMArrayBuffer> member_fingerprint_;
String member_fingerprint_digest_algorithm_;
V8RtcTransportSslRole member_ssl_role_{static_cast<V8RtcTransportSslRole::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DTLS_PARAMETERS_H_
