// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_dtls_fingerprint.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"algorithm",
"value",
};


}  // namespace 

RTCDtlsFingerprint* RTCDtlsFingerprint::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCDtlsFingerprint* dictionary = MakeGarbageCollected<RTCDtlsFingerprint>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCDtlsFingerprint";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCDtlsFingerprint::RTCDtlsFingerprint() {
  
}

 RTCDtlsFingerprint::RTCDtlsFingerprint(v8::Isolate* isolate) {
  
}



String RTCDtlsFingerprint::getAlgorithmOr(const String& fallback_value) const {
  if (!hasAlgorithm()) {
  return fallback_value;
}
return member_algorithm_;
}

String RTCDtlsFingerprint::getAlgorithmOr(String&& fallback_value) const {
  if (!hasAlgorithm()) {
  return std::move(fallback_value);
}
return member_algorithm_;
}

void RTCDtlsFingerprint::setAlgorithm(const String& value) {
  member_algorithm_ = value;
has_algorithm_ = true;
}

void RTCDtlsFingerprint::setAlgorithm(String&& value) {
  member_algorithm_ = std::move(value);
has_algorithm_ = true;
}




String RTCDtlsFingerprint::getValueOr(const String& fallback_value) const {
  if (!hasValue()) {
  return fallback_value;
}
return member_value_;
}

String RTCDtlsFingerprint::getValueOr(String&& fallback_value) const {
  if (!hasValue()) {
  return std::move(fallback_value);
}
return member_value_;
}

void RTCDtlsFingerprint::setValue(const String& value) {
  member_value_ = value;
has_value_ = true;
}

void RTCDtlsFingerprint::setValue(String&& value) {
  member_value_ = std::move(value);
has_value_ = true;
}



void RTCDtlsFingerprint::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void RTCDtlsFingerprint::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCDtlsFingerprint::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAlgorithm()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_algorithm_);
DCHECK(!values[0].IsEmpty());
}
if (hasValue()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_value_);
DCHECK(!values[1].IsEmpty());
}
}

const void* RTCDtlsFingerprint::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCDtlsFingerprint::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCDtlsFingerprint::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCDtlsFingerprint";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("algorithm");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_algorithm_, member_algorithm_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("value");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_value_, member_value_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCDtlsFingerprint::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
