// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_certificate_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"base64Certificate",
"fingerprint",
"fingerprintAlgorithm",
"issuerCertificateId",
};


}  // namespace 

RTCCertificateStats* RTCCertificateStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCCertificateStats* dictionary = MakeGarbageCollected<RTCCertificateStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCCertificateStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCCertificateStats::RTCCertificateStats() {
  
}

 RTCCertificateStats::RTCCertificateStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}



void RTCCertificateStats::setBase64Certificate(const String& value) {
  member_base_64_certificate_ = value;
}

void RTCCertificateStats::setBase64Certificate(String&& value) {
  member_base_64_certificate_ = std::move(value);
}




void RTCCertificateStats::setFingerprint(const String& value) {
  member_fingerprint_ = value;
}

void RTCCertificateStats::setFingerprint(String&& value) {
  member_fingerprint_ = std::move(value);
}




void RTCCertificateStats::setFingerprintAlgorithm(const String& value) {
  member_fingerprint_algorithm_ = value;
}

void RTCCertificateStats::setFingerprintAlgorithm(String&& value) {
  member_fingerprint_algorithm_ = std::move(value);
}




String RTCCertificateStats::getIssuerCertificateIdOr(const String& fallback_value) const {
  if (!hasIssuerCertificateId()) {
  return fallback_value;
}
return member_issuer_certificate_id_;
}

String RTCCertificateStats::getIssuerCertificateIdOr(String&& fallback_value) const {
  if (!hasIssuerCertificateId()) {
  return std::move(fallback_value);
}
return member_issuer_certificate_id_;
}

void RTCCertificateStats::setIssuerCertificateId(const String& value) {
  member_issuer_certificate_id_ = value;
has_issuer_certificate_id_ = true;
}

void RTCCertificateStats::setIssuerCertificateId(String&& value) {
  member_issuer_certificate_id_ = std::move(value);
has_issuer_certificate_id_ = true;
}



void RTCCertificateStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCCertificateStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCCertificateStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBase64Certificate()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_base_64_certificate_);
DCHECK(!values[0].IsEmpty());
}
if (hasFingerprint()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_fingerprint_);
DCHECK(!values[1].IsEmpty());
}
if (hasFingerprintAlgorithm()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_fingerprint_algorithm_);
DCHECK(!values[2].IsEmpty());
}
if (hasIssuerCertificateId()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_issuer_certificate_id_);
DCHECK(!values[3].IsEmpty());
}
}

const void* RTCCertificateStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCCertificateStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCCertificateStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCCertificateStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("base64Certificate");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_base_64_certificate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fingerprint");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_fingerprint_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fingerprintAlgorithm");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_fingerprint_algorithm_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("issuerCertificateId");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_issuer_certificate_id_, member_issuer_certificate_id_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCCertificateStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
