// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REQUEST_DEVICE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REQUEST_DEVICE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class BluetoothLEScanFilterInit;
class ExceptionState;
class V8UnionStringOrUnsignedLong;

class MODULES_EXPORT RequestDeviceOptions : public bindings::InputDictionaryBase {
  
  public:
static RequestDeviceOptions* Create() {
  return MakeGarbageCollected<RequestDeviceOptions>();
}
static RequestDeviceOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RequestDeviceOptions>(isolate);
}
static RequestDeviceOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RequestDeviceOptions();
explicit  RequestDeviceOptions(v8::Isolate* isolate);

bool hasAcceptAllDevices() const {
  return true;
}
bool acceptAllDevices() const {
  return member_accept_all_devices_;
}
void setAcceptAllDevices(bool value) {
  member_accept_all_devices_ = value;
}

bool hasExclusionFilters() const {
  return has_exclusion_filters_;
}
const HeapVector<Member<BluetoothLEScanFilterInit>>& exclusionFilters() const {
  DCHECK(hasExclusionFilters());
return member_exclusion_filters_;
}
HeapVector<Member<BluetoothLEScanFilterInit>> getExclusionFiltersOr(const HeapVector<Member<BluetoothLEScanFilterInit>>& fallback_value) const;
HeapVector<Member<BluetoothLEScanFilterInit>> getExclusionFiltersOr(HeapVector<Member<BluetoothLEScanFilterInit>>&& fallback_value) const;
void setExclusionFilters(const HeapVector<Member<BluetoothLEScanFilterInit>>& value);
void setExclusionFilters(HeapVector<Member<BluetoothLEScanFilterInit>>&& value);

bool hasFilters() const {
  return has_filters_;
}
const HeapVector<Member<BluetoothLEScanFilterInit>>& filters() const {
  DCHECK(hasFilters());
return member_filters_;
}
HeapVector<Member<BluetoothLEScanFilterInit>> getFiltersOr(const HeapVector<Member<BluetoothLEScanFilterInit>>& fallback_value) const;
HeapVector<Member<BluetoothLEScanFilterInit>> getFiltersOr(HeapVector<Member<BluetoothLEScanFilterInit>>&& fallback_value) const;
void setFilters(const HeapVector<Member<BluetoothLEScanFilterInit>>& value);
void setFilters(HeapVector<Member<BluetoothLEScanFilterInit>>&& value);

bool hasOptionalManufacturerData() const {
  return true;
}
const Vector<uint16_t>& optionalManufacturerData() const {
  return member_optional_manufacturer_data_;
}
void setOptionalManufacturerData(const Vector<uint16_t>& value);
void setOptionalManufacturerData(Vector<uint16_t>&& value);

bool hasOptionalServices() const {
  return true;
}
const HeapVector<Member<V8UnionStringOrUnsignedLong>>& optionalServices() const {
  return member_optional_services_;
}
void setOptionalServices(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value);
void setOptionalServices(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_exclusion_filters_ = false;
bool has_filters_ = false;

bool member_accept_all_devices_{false};
HeapVector<Member<BluetoothLEScanFilterInit>> member_exclusion_filters_;
HeapVector<Member<BluetoothLEScanFilterInit>> member_filters_;
Vector<uint16_t> member_optional_manufacturer_data_;
HeapVector<Member<V8UnionStringOrUnsignedLong>> member_optional_services_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REQUEST_DEVICE_OPTIONS_H_
