// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_QUERY_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_QUERY_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT QueryOptions : public bindings::InputDictionaryBase {
  
  public:
static QueryOptions* Create() {
  return MakeGarbageCollected<QueryOptions>();
}
static QueryOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<QueryOptions>(isolate);
}
static QueryOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  QueryOptions();
explicit  QueryOptions(v8::Isolate* isolate);

bool hasPostscriptNames() const {
  return has_postscript_names_;
}
const Vector<String>& postscriptNames() const {
  DCHECK(hasPostscriptNames());
return member_postscript_names_;
}
Vector<String> getPostscriptNamesOr(const Vector<String>& fallback_value) const;
Vector<String> getPostscriptNamesOr(Vector<String>&& fallback_value) const;
void setPostscriptNames(const Vector<String>& value);
void setPostscriptNames(Vector<String>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_postscript_names_ = false;

Vector<String> member_postscript_names_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_QUERY_OPTIONS_H_
