// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_CREATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_CREATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsClientInputs;
class AuthenticatorSelectionCriteria;
class ExceptionState;
class PublicKeyCredentialDescriptor;
class PublicKeyCredentialParameters;
class PublicKeyCredentialRpEntity;
class PublicKeyCredentialUserEntity;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT PublicKeyCredentialCreationOptions : public bindings::DictionaryBase {
  
  public:
static PublicKeyCredentialCreationOptions* Create() {
  return MakeGarbageCollected<PublicKeyCredentialCreationOptions>();
}
static PublicKeyCredentialCreationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PublicKeyCredentialCreationOptions>(isolate);
}
static PublicKeyCredentialCreationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PublicKeyCredentialCreationOptions();
explicit  PublicKeyCredentialCreationOptions(v8::Isolate* isolate);

bool hasAttestation() const {
  return has_attestation_;
}
const String& attestation() const {
  DCHECK(hasAttestation());
return member_attestation_;
}
String getAttestationOr(const String& fallback_value) const;
String getAttestationOr(String&& fallback_value) const;
void setAttestation(const String& value);
void setAttestation(String&& value);

bool hasAttestationFormats() const {
  return true;
}
const Vector<String>& attestationFormats() const {
  return member_attestation_formats_;
}
void setAttestationFormats(const Vector<String>& value);
void setAttestationFormats(Vector<String>&& value);

bool hasAuthenticatorSelection() const {
  return has_authenticator_selection_;
}
AuthenticatorSelectionCriteria* authenticatorSelection() const {
  DCHECK(hasAuthenticatorSelection());
return member_authenticator_selection_.Get();
}
AuthenticatorSelectionCriteria* getAuthenticatorSelectionOr(AuthenticatorSelectionCriteria* fallback_value) const {
  if (!hasAuthenticatorSelection()) {
  return fallback_value;
}
return member_authenticator_selection_.Get();
}
void setAuthenticatorSelection(AuthenticatorSelectionCriteria* value) {
  member_authenticator_selection_ = value;
has_authenticator_selection_ = true;
DCHECK(member_authenticator_selection_);
}

bool hasChallenge() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* challenge() const {
  return member_challenge_.Get();
}
void setChallenge(V8UnionArrayBufferOrArrayBufferView* value) {
  member_challenge_ = value;
DCHECK(member_challenge_);
}

bool hasExcludeCredentials() const {
  return true;
}
const HeapVector<Member<PublicKeyCredentialDescriptor>>& excludeCredentials() const {
  return member_exclude_credentials_;
}
void setExcludeCredentials(const HeapVector<Member<PublicKeyCredentialDescriptor>>& value);
void setExcludeCredentials(HeapVector<Member<PublicKeyCredentialDescriptor>>&& value);

bool hasExtensions() const {
  return has_extensions_;
}
AuthenticationExtensionsClientInputs* extensions() const {
  DCHECK(hasExtensions());
return member_extensions_.Get();
}
AuthenticationExtensionsClientInputs* getExtensionsOr(AuthenticationExtensionsClientInputs* fallback_value) const {
  if (!hasExtensions()) {
  return fallback_value;
}
return member_extensions_.Get();
}
void setExtensions(AuthenticationExtensionsClientInputs* value) {
  member_extensions_ = value;
has_extensions_ = true;
DCHECK(member_extensions_);
}

bool hasHints() const {
  return true;
}
const Vector<String>& hints() const {
  return member_hints_;
}
void setHints(const Vector<String>& value);
void setHints(Vector<String>&& value);

bool hasPubKeyCredParams() const {
  return true;
}
const HeapVector<Member<PublicKeyCredentialParameters>>& pubKeyCredParams() const {
  return member_pub_key_cred_params_;
}
void setPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value);
void setPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value);

bool hasRp() const {
  return true;
}
PublicKeyCredentialRpEntity* rp() const {
  return member_rp_.Get();
}
void setRp(PublicKeyCredentialRpEntity* value) {
  member_rp_ = value;
DCHECK(member_rp_);
}

bool hasTimeout() const {
  return has_timeout_;
}
uint32_t timeout() const {
  DCHECK(hasTimeout());
return member_timeout_;
}
uint32_t getTimeoutOr(uint32_t fallback_value) const {
  if (!hasTimeout()) {
  return fallback_value;
}
return member_timeout_;
}
void setTimeout(uint32_t value) {
  member_timeout_ = value;
has_timeout_ = true;
}

bool hasUser() const {
  return true;
}
PublicKeyCredentialUserEntity* user() const {
  return member_user_.Get();
}
void setUser(PublicKeyCredentialUserEntity* value) {
  member_user_ = value;
DCHECK(member_user_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 11;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_attestation_ = false;
bool has_authenticator_selection_ = false;
bool has_extensions_ = false;
bool has_timeout_ = false;

String member_attestation_;
Vector<String> member_attestation_formats_;
Member<AuthenticatorSelectionCriteria> member_authenticator_selection_;
Member<V8UnionArrayBufferOrArrayBufferView> member_challenge_;
HeapVector<Member<PublicKeyCredentialDescriptor>> member_exclude_credentials_;
Member<AuthenticationExtensionsClientInputs> member_extensions_;
Vector<String> member_hints_;
HeapVector<Member<PublicKeyCredentialParameters>> member_pub_key_cred_params_;
Member<PublicKeyCredentialRpEntity> member_rp_;
uint32_t member_timeout_;
Member<PublicKeyCredentialUserEntity> member_user_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_CREATION_OPTIONS_H_
