// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PHOTO_CAPABILITIES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PHOTO_CAPABILITIES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_fill_light_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_red_eye_reduction.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaSettingsRange;

class MODULES_EXPORT PhotoCapabilities : public bindings::DictionaryBase {
  
  public:
static PhotoCapabilities* Create() {
  return MakeGarbageCollected<PhotoCapabilities>();
}
static PhotoCapabilities* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PhotoCapabilities>(isolate);
}
static PhotoCapabilities* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PhotoCapabilities();
explicit  PhotoCapabilities(v8::Isolate* isolate);

bool hasFillLightMode() const {
  return has_fill_light_mode_;
}
const Vector<V8FillLightMode>& fillLightMode() const {
  DCHECK(hasFillLightMode());
return member_fill_light_mode_;
}
Vector<V8FillLightMode> getFillLightModeOr(const Vector<V8FillLightMode>& fallback_value) const;
Vector<V8FillLightMode> getFillLightModeOr(Vector<V8FillLightMode>&& fallback_value) const;
void setFillLightMode(const Vector<V8FillLightMode>& value);
void setFillLightMode(Vector<V8FillLightMode>&& value);

bool hasImageHeight() const {
  return has_image_height_;
}
MediaSettingsRange* imageHeight() const {
  DCHECK(hasImageHeight());
return member_image_height_.Get();
}
MediaSettingsRange* getImageHeightOr(MediaSettingsRange* fallback_value) const {
  if (!hasImageHeight()) {
  return fallback_value;
}
return member_image_height_.Get();
}
void setImageHeight(MediaSettingsRange* value) {
  member_image_height_ = value;
has_image_height_ = true;
DCHECK(member_image_height_);
}

bool hasImageWidth() const {
  return has_image_width_;
}
MediaSettingsRange* imageWidth() const {
  DCHECK(hasImageWidth());
return member_image_width_.Get();
}
MediaSettingsRange* getImageWidthOr(MediaSettingsRange* fallback_value) const {
  if (!hasImageWidth()) {
  return fallback_value;
}
return member_image_width_.Get();
}
void setImageWidth(MediaSettingsRange* value) {
  member_image_width_ = value;
has_image_width_ = true;
DCHECK(member_image_width_);
}

bool hasRedEyeReduction() const {
  return has_red_eye_reduction_;
}
V8RedEyeReduction redEyeReduction() const {
  DCHECK(hasRedEyeReduction());
return member_red_eye_reduction_;
}
V8RedEyeReduction getRedEyeReductionOr(V8RedEyeReduction fallback_value) const {
  if (!hasRedEyeReduction()) {
  return fallback_value;
}
return member_red_eye_reduction_;
}
void setRedEyeReduction(V8RedEyeReduction value) {
  member_red_eye_reduction_ = value;
has_red_eye_reduction_ = true;
}
void setRedEyeReduction(V8RedEyeReduction::Enum value) {
  member_red_eye_reduction_ = V8RedEyeReduction(value);
has_red_eye_reduction_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_fill_light_mode_ = false;
bool has_image_height_ = false;
bool has_image_width_ = false;
bool has_red_eye_reduction_ = false;

Vector<V8FillLightMode> member_fill_light_mode_;
Member<MediaSettingsRange> member_image_height_;
Member<MediaSettingsRange> member_image_width_;
V8RedEyeReduction member_red_eye_reduction_{static_cast<V8RedEyeReduction::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PHOTO_CAPABILITIES_H_
