// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_VALIDATION_ERRORS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_VALIDATION_ERRORS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AddressErrors;
class ExceptionState;
class PayerErrors;

class MODULES_EXPORT PaymentValidationErrors : public bindings::InputDictionaryBase {
  
  public:
static PaymentValidationErrors* Create() {
  return MakeGarbageCollected<PaymentValidationErrors>();
}
static PaymentValidationErrors* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentValidationErrors>(isolate);
}
static PaymentValidationErrors* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentValidationErrors();
explicit  PaymentValidationErrors(v8::Isolate* isolate);

bool hasError() const {
  return has_error_;
}
const String& error() const {
  DCHECK(hasError());
return member_error_;
}
String getErrorOr(const String& fallback_value) const;
String getErrorOr(String&& fallback_value) const;
void setError(const String& value);
void setError(String&& value);

bool hasPayer() const {
  return has_payer_;
}
PayerErrors* payer() const {
  DCHECK(hasPayer());
return member_payer_.Get();
}
PayerErrors* getPayerOr(PayerErrors* fallback_value) const {
  if (!hasPayer()) {
  return fallback_value;
}
return member_payer_.Get();
}
void setPayer(PayerErrors* value) {
  member_payer_ = value;
has_payer_ = true;
DCHECK(member_payer_);
}

bool hasShippingAddress() const {
  return has_shipping_address_;
}
AddressErrors* shippingAddress() const {
  DCHECK(hasShippingAddress());
return member_shipping_address_.Get();
}
AddressErrors* getShippingAddressOr(AddressErrors* fallback_value) const {
  if (!hasShippingAddress()) {
  return fallback_value;
}
return member_shipping_address_.Get();
}
void setShippingAddress(AddressErrors* value) {
  member_shipping_address_ = value;
has_shipping_address_ = true;
DCHECK(member_shipping_address_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_error_ = false;
bool has_payer_ = false;
bool has_shipping_address_ = false;

String member_error_;
Member<PayerErrors> member_payer_;
Member<AddressErrors> member_shipping_address_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_VALIDATION_ERRORS_H_
