// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_request_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_currency_amount.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_modifier.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_method_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_shipping_option.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"instrumentKey",
"methodData",
"modifiers",
"paymentOptions",
"paymentRequestId",
"paymentRequestOrigin",
"shippingOptions",
"topOrigin",
"total",
};


}  // namespace 

PaymentRequestEventInit* PaymentRequestEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PaymentRequestEventInit* dictionary = MakeGarbageCollected<PaymentRequestEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PaymentRequestEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PaymentRequestEventInit::PaymentRequestEventInit() {
  
}

 PaymentRequestEventInit::PaymentRequestEventInit(v8::Isolate* isolate) : ExtendableEventInit(isolate) {
  
}



String PaymentRequestEventInit::getInstrumentKeyOr(const String& fallback_value) const {
  if (!hasInstrumentKey()) {
  return fallback_value;
}
return member_instrument_key_;
}

String PaymentRequestEventInit::getInstrumentKeyOr(String&& fallback_value) const {
  if (!hasInstrumentKey()) {
  return std::move(fallback_value);
}
return member_instrument_key_;
}

void PaymentRequestEventInit::setInstrumentKey(const String& value) {
  member_instrument_key_ = value;
has_instrument_key_ = true;
}

void PaymentRequestEventInit::setInstrumentKey(String&& value) {
  member_instrument_key_ = std::move(value);
has_instrument_key_ = true;
}




HeapVector<Member<PaymentMethodData>> PaymentRequestEventInit::getMethodDataOr(const HeapVector<Member<PaymentMethodData>>& fallback_value) const {
  if (!hasMethodData()) {
  return fallback_value;
}
return member_method_data_;
}

HeapVector<Member<PaymentMethodData>> PaymentRequestEventInit::getMethodDataOr(HeapVector<Member<PaymentMethodData>>&& fallback_value) const {
  if (!hasMethodData()) {
  return std::move(fallback_value);
}
return member_method_data_;
}

void PaymentRequestEventInit::setMethodData(const HeapVector<Member<PaymentMethodData>>& value) {
  member_method_data_ = value;
has_method_data_ = true;
}

void PaymentRequestEventInit::setMethodData(HeapVector<Member<PaymentMethodData>>&& value) {
  member_method_data_ = std::move(value);
has_method_data_ = true;
}




HeapVector<Member<PaymentDetailsModifier>> PaymentRequestEventInit::getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const {
  if (!hasModifiers()) {
  return fallback_value;
}
return member_modifiers_;
}

HeapVector<Member<PaymentDetailsModifier>> PaymentRequestEventInit::getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const {
  if (!hasModifiers()) {
  return std::move(fallback_value);
}
return member_modifiers_;
}

void PaymentRequestEventInit::setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value) {
  member_modifiers_ = value;
has_modifiers_ = true;
}

void PaymentRequestEventInit::setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value) {
  member_modifiers_ = std::move(value);
has_modifiers_ = true;
}











String PaymentRequestEventInit::getPaymentRequestIdOr(const String& fallback_value) const {
  if (!hasPaymentRequestId()) {
  return fallback_value;
}
return member_payment_request_id_;
}

String PaymentRequestEventInit::getPaymentRequestIdOr(String&& fallback_value) const {
  if (!hasPaymentRequestId()) {
  return std::move(fallback_value);
}
return member_payment_request_id_;
}

void PaymentRequestEventInit::setPaymentRequestId(const String& value) {
  member_payment_request_id_ = value;
has_payment_request_id_ = true;
}

void PaymentRequestEventInit::setPaymentRequestId(String&& value) {
  member_payment_request_id_ = std::move(value);
has_payment_request_id_ = true;
}




String PaymentRequestEventInit::getPaymentRequestOriginOr(const String& fallback_value) const {
  if (!hasPaymentRequestOrigin()) {
  return fallback_value;
}
return member_payment_request_origin_;
}

String PaymentRequestEventInit::getPaymentRequestOriginOr(String&& fallback_value) const {
  if (!hasPaymentRequestOrigin()) {
  return std::move(fallback_value);
}
return member_payment_request_origin_;
}

void PaymentRequestEventInit::setPaymentRequestOrigin(const String& value) {
  member_payment_request_origin_ = value;
has_payment_request_origin_ = true;
}

void PaymentRequestEventInit::setPaymentRequestOrigin(String&& value) {
  member_payment_request_origin_ = std::move(value);
has_payment_request_origin_ = true;
}




HeapVector<Member<PaymentShippingOption>> PaymentRequestEventInit::getShippingOptionsOr(const HeapVector<Member<PaymentShippingOption>>& fallback_value) const {
  if (!hasShippingOptions()) {
  return fallback_value;
}
return member_shipping_options_;
}

HeapVector<Member<PaymentShippingOption>> PaymentRequestEventInit::getShippingOptionsOr(HeapVector<Member<PaymentShippingOption>>&& fallback_value) const {
  if (!hasShippingOptions()) {
  return std::move(fallback_value);
}
return member_shipping_options_;
}

void PaymentRequestEventInit::setShippingOptions(const HeapVector<Member<PaymentShippingOption>>& value) {
  member_shipping_options_ = value;
has_shipping_options_ = true;
}

void PaymentRequestEventInit::setShippingOptions(HeapVector<Member<PaymentShippingOption>>&& value) {
  member_shipping_options_ = std::move(value);
has_shipping_options_ = true;
}




String PaymentRequestEventInit::getTopOriginOr(const String& fallback_value) const {
  if (!hasTopOrigin()) {
  return fallback_value;
}
return member_top_origin_;
}

String PaymentRequestEventInit::getTopOriginOr(String&& fallback_value) const {
  if (!hasTopOrigin()) {
  return std::move(fallback_value);
}
return member_top_origin_;
}

void PaymentRequestEventInit::setTopOrigin(const String& value) {
  member_top_origin_ = value;
has_top_origin_ = true;
}

void PaymentRequestEventInit::setTopOrigin(String&& value) {
  member_top_origin_ = std::move(value);
has_top_origin_ = true;
}










void PaymentRequestEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_method_data_);
visitor->Trace(member_modifiers_);
visitor->Trace(member_payment_options_);
visitor->Trace(member_shipping_options_);
visitor->Trace(member_total_);
ExtendableEventInit::Trace(visitor);
}

void PaymentRequestEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
ExtendableEventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "PaymentRequestEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("instrumentKey");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_instrument_key_, member_instrument_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("methodData");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentMethodData>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_method_data_, member_method_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("modifiers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentDetailsModifier>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_modifiers_, member_modifiers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("paymentOptions");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_payment_options_, member_payment_options_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("paymentRequestId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_payment_request_id_, member_payment_request_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("paymentRequestOrigin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_payment_request_origin_, member_payment_request_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shippingOptions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentShippingOption>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_shipping_options_, member_shipping_options_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("topOrigin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_top_origin_, member_top_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("total");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentCurrencyAmount, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_total_, member_total_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PaymentRequestEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
