// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_details_modifier.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_item.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"additionalDisplayItems",
"data",
"supportedMethods",
"total",
};


}  // namespace 

PaymentDetailsModifier* PaymentDetailsModifier::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PaymentDetailsModifier* dictionary = MakeGarbageCollected<PaymentDetailsModifier>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PaymentDetailsModifier";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PaymentDetailsModifier::PaymentDetailsModifier() {
  
}

 PaymentDetailsModifier::PaymentDetailsModifier(v8::Isolate* isolate) {
  
}



HeapVector<Member<PaymentItem>> PaymentDetailsModifier::getAdditionalDisplayItemsOr(const HeapVector<Member<PaymentItem>>& fallback_value) const {
  if (!hasAdditionalDisplayItems()) {
  return fallback_value;
}
return member_additional_display_items_;
}

HeapVector<Member<PaymentItem>> PaymentDetailsModifier::getAdditionalDisplayItemsOr(HeapVector<Member<PaymentItem>>&& fallback_value) const {
  if (!hasAdditionalDisplayItems()) {
  return std::move(fallback_value);
}
return member_additional_display_items_;
}

void PaymentDetailsModifier::setAdditionalDisplayItems(const HeapVector<Member<PaymentItem>>& value) {
  member_additional_display_items_ = value;
has_additional_display_items_ = true;
}

void PaymentDetailsModifier::setAdditionalDisplayItems(HeapVector<Member<PaymentItem>>&& value) {
  member_additional_display_items_ = std::move(value);
has_additional_display_items_ = true;
}











void PaymentDetailsModifier::setSupportedMethod(const String& value) {
  member_supported_method_ = value;
}

void PaymentDetailsModifier::setSupportedMethod(String&& value) {
  member_supported_method_ = std::move(value);
}










void PaymentDetailsModifier::Trace(Visitor* visitor) const {
  visitor->Trace(member_additional_display_items_);
visitor->Trace(member_data_);
visitor->Trace(member_total_);
bindings::DictionaryBase::Trace(visitor);
}

void PaymentDetailsModifier::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PaymentDetailsModifier::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAdditionalDisplayItems()) {
  values[0] = ToV8Traits<IDLSequence<PaymentItem>>::ToV8(script_state, member_additional_display_items_);
DCHECK(!values[0].IsEmpty());
}
if (hasData()) {
  values[1] = ToV8Traits<IDLObject>::ToV8(script_state, member_data_);
DCHECK(!values[1].IsEmpty());
}
if (hasSupportedMethod()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_supported_method_);
DCHECK(!values[2].IsEmpty());
}
if (hasTotal()) {
  values[3] = ToV8Traits<PaymentItem>::ToV8(script_state, member_total_.Get());
DCHECK(!values[3].IsEmpty());
}
}

const void* PaymentDetailsModifier::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PaymentDetailsModifier::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PaymentDetailsModifier::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PaymentDetailsModifier";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("additionalDisplayItems");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentItem>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_additional_display_items_, member_additional_display_items_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("data");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_data_, member_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("supportedMethods");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_supported_method_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("total");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentItem, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_total_, member_total_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PaymentDetailsModifier::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
