// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PASSWORD_CREDENTIAL_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PASSWORD_CREDENTIAL_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_credential_data.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PasswordCredentialData : public CredentialData {
  
  public:
static PasswordCredentialData* Create() {
  return MakeGarbageCollected<PasswordCredentialData>();
}
static PasswordCredentialData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PasswordCredentialData>(isolate);
}
static PasswordCredentialData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PasswordCredentialData();
explicit  PasswordCredentialData(v8::Isolate* isolate);

bool hasIconURL() const {
  return has_icon_url_;
}
const String& iconURL() const {
  DCHECK(hasIconURL());
return member_icon_url_;
}
String getIconURLOr(const String& fallback_value) const;
String getIconURLOr(String&& fallback_value) const;
void setIconURL(const String& value);
void setIconURL(String&& value);

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasPassword() const {
  return true;
}
const String& password() const {
  return member_password_;
}
void setPassword(const String& value);
void setPassword(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = CredentialData::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_icon_url_ = false;
bool has_name_ = false;

String member_icon_url_;
String member_name_;
String member_password_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PASSWORD_CREDENTIAL_DATA_H_
