// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PANNER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PANNER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_distance_model_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_panning_model_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PannerOptions : public AudioNodeOptions {
  
  public:
static PannerOptions* Create() {
  return MakeGarbageCollected<PannerOptions>();
}
static PannerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PannerOptions>(isolate);
}
static PannerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PannerOptions();
explicit  PannerOptions(v8::Isolate* isolate);

bool hasConeInnerAngle() const {
  return true;
}
double coneInnerAngle() const {
  return member_cone_inner_angle_;
}
void setConeInnerAngle(double value) {
  member_cone_inner_angle_ = value;
}

bool hasConeOuterAngle() const {
  return true;
}
double coneOuterAngle() const {
  return member_cone_outer_angle_;
}
void setConeOuterAngle(double value) {
  member_cone_outer_angle_ = value;
}

bool hasConeOuterGain() const {
  return true;
}
double coneOuterGain() const {
  return member_cone_outer_gain_;
}
void setConeOuterGain(double value) {
  member_cone_outer_gain_ = value;
}

bool hasDistanceModel() const {
  return true;
}
V8DistanceModelType distanceModel() const {
  return member_distance_model_;
}
void setDistanceModel(V8DistanceModelType value) {
  member_distance_model_ = value;
}
void setDistanceModel(V8DistanceModelType::Enum value) {
  member_distance_model_ = V8DistanceModelType(value);
}

bool hasMaxDistance() const {
  return true;
}
double maxDistance() const {
  return member_max_distance_;
}
void setMaxDistance(double value) {
  member_max_distance_ = value;
}

bool hasOrientationX() const {
  return true;
}
float orientationX() const {
  return member_orientation_x_;
}
void setOrientationX(float value) {
  member_orientation_x_ = value;
}

bool hasOrientationY() const {
  return true;
}
float orientationY() const {
  return member_orientation_y_;
}
void setOrientationY(float value) {
  member_orientation_y_ = value;
}

bool hasOrientationZ() const {
  return true;
}
float orientationZ() const {
  return member_orientation_z_;
}
void setOrientationZ(float value) {
  member_orientation_z_ = value;
}

bool hasPanningModel() const {
  return true;
}
V8PanningModelType panningModel() const {
  return member_panning_model_;
}
void setPanningModel(V8PanningModelType value) {
  member_panning_model_ = value;
}
void setPanningModel(V8PanningModelType::Enum value) {
  member_panning_model_ = V8PanningModelType(value);
}

bool hasPositionX() const {
  return true;
}
float positionX() const {
  return member_position_x_;
}
void setPositionX(float value) {
  member_position_x_ = value;
}

bool hasPositionY() const {
  return true;
}
float positionY() const {
  return member_position_y_;
}
void setPositionY(float value) {
  member_position_y_ = value;
}

bool hasPositionZ() const {
  return true;
}
float positionZ() const {
  return member_position_z_;
}
void setPositionZ(float value) {
  member_position_z_ = value;
}

bool hasRefDistance() const {
  return true;
}
double refDistance() const {
  return member_ref_distance_;
}
void setRefDistance(double value) {
  member_ref_distance_ = value;
}

bool hasRolloffFactor() const {
  return true;
}
double rolloffFactor() const {
  return member_rolloff_factor_;
}
void setRolloffFactor(double value) {
  member_rolloff_factor_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 14;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



double member_cone_inner_angle_{360};
double member_cone_outer_angle_{360};
double member_cone_outer_gain_{0};
V8DistanceModelType member_distance_model_{V8DistanceModelType::Enum::kInverse};
double member_max_distance_{10000};
float member_orientation_x_{1};
float member_orientation_y_{0};
float member_orientation_z_{0};
V8PanningModelType member_panning_model_{V8PanningModelType::Enum::kEqualpower};
float member_position_x_{0};
float member_position_y_{0};
float member_position_z_{0};
double member_ref_distance_{1};
double member_rolloff_factor_{1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PANNER_OPTIONS_H_
