// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_TENSOR_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_TENSOR_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MLRankRange;

class MODULES_EXPORT MLTensorLimits : public bindings::DictionaryBase {
  
  public:
static MLTensorLimits* Create() {
  return MakeGarbageCollected<MLTensorLimits>();
}
static MLTensorLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLTensorLimits>(isolate);
}
static MLTensorLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLTensorLimits();
explicit  MLTensorLimits(v8::Isolate* isolate);

bool hasDataTypes() const {
  return has_data_types_;
}
const Vector<String>& dataTypes() const {
  DCHECK(hasDataTypes());
return member_data_types_;
}
Vector<String> getDataTypesOr(const Vector<String>& fallback_value) const;
Vector<String> getDataTypesOr(Vector<String>&& fallback_value) const;
void setDataTypes(const Vector<String>& value);
void setDataTypes(Vector<String>&& value);

bool hasRankRange() const {
  return has_rank_range_;
}
MLRankRange* rankRange() const {
  DCHECK(hasRankRange());
return member_rank_range_.Get();
}
MLRankRange* getRankRangeOr(MLRankRange* fallback_value) const {
  if (!hasRankRange()) {
  return fallback_value;
}
return member_rank_range_.Get();
}
void setRankRange(MLRankRange* value) {
  member_rank_range_ = value;
has_rank_range_ = true;
DCHECK(member_rank_range_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_types_ = false;
bool has_rank_range_ = false;

Vector<String> member_data_types_;
Member<MLRankRange> member_rank_range_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_TENSOR_LIMITS_H_
