// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_LAYER_NORMALIZATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_LAYER_NORMALIZATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLOperand;

class MODULES_EXPORT MLLayerNormalizationOptions : public MLOperatorOptions {
  
  public:
static MLLayerNormalizationOptions* Create() {
  return MakeGarbageCollected<MLLayerNormalizationOptions>();
}
static MLLayerNormalizationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLLayerNormalizationOptions>(isolate);
}
static MLLayerNormalizationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLLayerNormalizationOptions();
explicit  MLLayerNormalizationOptions(v8::Isolate* isolate);

bool hasAxes() const {
  return has_axes_;
}
const Vector<uint32_t>& axes() const {
  DCHECK(hasAxes());
return member_axes_;
}
Vector<uint32_t> getAxesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getAxesOr(Vector<uint32_t>&& fallback_value) const;
void setAxes(const Vector<uint32_t>& value);
void setAxes(Vector<uint32_t>&& value);

bool hasBias() const {
  return has_bias_;
}
MLOperand* bias() const {
  DCHECK(hasBias());
return member_bias_.Get();
}
MLOperand* getBiasOr(MLOperand* fallback_value) const {
  if (!hasBias()) {
  return fallback_value;
}
return member_bias_.Get();
}
void setBias(MLOperand* value) {
  member_bias_ = value;
has_bias_ = true;
DCHECK(member_bias_);
}

bool hasEpsilon() const {
  return true;
}
float epsilon() const {
  return member_epsilon_;
}
void setEpsilon(float value) {
  member_epsilon_ = value;
}

bool hasScale() const {
  return has_scale_;
}
MLOperand* scale() const {
  DCHECK(hasScale());
return member_scale_.Get();
}
MLOperand* getScaleOr(MLOperand* fallback_value) const {
  if (!hasScale()) {
  return fallback_value;
}
return member_scale_.Get();
}
void setScale(MLOperand* value) {
  member_scale_ = value;
has_scale_ = true;
DCHECK(member_scale_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_axes_ = false;
bool has_bias_ = false;
bool has_scale_ = false;

Vector<uint32_t> member_axes_;
Member<MLOperand> member_bias_;
float member_epsilon_{1e-5};
Member<MLOperand> member_scale_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_LAYER_NORMALIZATION_OPTIONS_H_
