// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_SUPPORTED_CONSTRAINTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_SUPPORTED_CONSTRAINTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaTrackSupportedConstraints : public bindings::DictionaryBase {
  
  public:
static MediaTrackSupportedConstraints* Create() {
  return MakeGarbageCollected<MediaTrackSupportedConstraints>();
}
static MediaTrackSupportedConstraints* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaTrackSupportedConstraints>(isolate);
}
static MediaTrackSupportedConstraints* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaTrackSupportedConstraints();
explicit  MediaTrackSupportedConstraints(v8::Isolate* isolate);

bool hasAspectRatio() const {
  return true;
}
bool aspectRatio() const {
  return member_aspect_ratio_;
}
void setAspectRatio(bool value) {
  member_aspect_ratio_ = value;
}

bool hasAutoGainControl() const {
  return true;
}
bool autoGainControl() const {
  return member_auto_gain_control_;
}
void setAutoGainControl(bool value) {
  member_auto_gain_control_ = value;
}

bool hasBackgroundBlur() const {
  return true;
}
bool backgroundBlur() const {
  return member_background_blur_;
}
void setBackgroundBlur(bool value) {
  member_background_blur_ = value;
}

bool hasBackgroundSegmentationMask() const {
  return true;
}
bool backgroundSegmentationMask() const {
  return member_background_segmentation_mask_;
}
void setBackgroundSegmentationMask(bool value) {
  member_background_segmentation_mask_ = value;
}

bool hasBrightness() const {
  return true;
}
bool brightness() const {
  return member_brightness_;
}
void setBrightness(bool value) {
  member_brightness_ = value;
}

bool hasChannelCount() const {
  return true;
}
bool channelCount() const {
  return member_channel_count_;
}
void setChannelCount(bool value) {
  member_channel_count_ = value;
}

bool hasColorTemperature() const {
  return true;
}
bool colorTemperature() const {
  return member_color_temperature_;
}
void setColorTemperature(bool value) {
  member_color_temperature_ = value;
}

bool hasContrast() const {
  return true;
}
bool contrast() const {
  return member_contrast_;
}
void setContrast(bool value) {
  member_contrast_ = value;
}

bool hasDeviceId() const {
  return true;
}
bool deviceId() const {
  return member_device_id_;
}
void setDeviceId(bool value) {
  member_device_id_ = value;
}

bool hasDisplaySurface() const {
  return true;
}
bool displaySurface() const {
  return member_display_surface_;
}
void setDisplaySurface(bool value) {
  member_display_surface_ = value;
}

bool hasEchoCancellation() const {
  return true;
}
bool echoCancellation() const {
  return member_echo_cancellation_;
}
void setEchoCancellation(bool value) {
  member_echo_cancellation_ = value;
}

bool hasExposureCompensation() const {
  return true;
}
bool exposureCompensation() const {
  return member_exposure_compensation_;
}
void setExposureCompensation(bool value) {
  member_exposure_compensation_ = value;
}

bool hasExposureMode() const {
  return true;
}
bool exposureMode() const {
  return member_exposure_mode_;
}
void setExposureMode(bool value) {
  member_exposure_mode_ = value;
}

bool hasExposureTime() const {
  return true;
}
bool exposureTime() const {
  return member_exposure_time_;
}
void setExposureTime(bool value) {
  member_exposure_time_ = value;
}

bool hasEyeGazeCorrection() const {
  return true;
}
bool eyeGazeCorrection() const {
  return member_eye_gaze_correction_;
}
void setEyeGazeCorrection(bool value) {
  member_eye_gaze_correction_ = value;
}

bool hasFaceFraming() const {
  return true;
}
bool faceFraming() const {
  return member_face_framing_;
}
void setFaceFraming(bool value) {
  member_face_framing_ = value;
}

bool hasFacingMode() const {
  return true;
}
bool facingMode() const {
  return member_facing_mode_;
}
void setFacingMode(bool value) {
  member_facing_mode_ = value;
}

bool hasFocusDistance() const {
  return true;
}
bool focusDistance() const {
  return member_focus_distance_;
}
void setFocusDistance(bool value) {
  member_focus_distance_ = value;
}

bool hasFocusMode() const {
  return true;
}
bool focusMode() const {
  return member_focus_mode_;
}
void setFocusMode(bool value) {
  member_focus_mode_ = value;
}

bool hasFrameRate() const {
  return true;
}
bool frameRate() const {
  return member_frame_rate_;
}
void setFrameRate(bool value) {
  member_frame_rate_ = value;
}

bool hasGroupId() const {
  return true;
}
bool groupId() const {
  return member_group_id_;
}
void setGroupId(bool value) {
  member_group_id_ = value;
}

bool hasHeight() const {
  return true;
}
bool height() const {
  return member_height_;
}
void setHeight(bool value) {
  member_height_ = value;
}

bool hasIso() const {
  return true;
}
bool iso() const {
  return member_iso_;
}
void setIso(bool value) {
  member_iso_ = value;
}

bool hasLatency() const {
  return true;
}
bool latency() const {
  return member_latency_;
}
void setLatency(bool value) {
  member_latency_ = value;
}

bool hasNoiseSuppression() const {
  return true;
}
bool noiseSuppression() const {
  return member_noise_suppression_;
}
void setNoiseSuppression(bool value) {
  member_noise_suppression_ = value;
}

bool hasPan() const {
  return true;
}
bool pan() const {
  return member_pan_;
}
void setPan(bool value) {
  member_pan_ = value;
}

bool hasPointsOfInterest() const {
  return true;
}
bool pointsOfInterest() const {
  return member_points_of_interest_;
}
void setPointsOfInterest(bool value) {
  member_points_of_interest_ = value;
}

bool hasResizeMode() const {
  return true;
}
bool resizeMode() const {
  return member_resize_mode_;
}
void setResizeMode(bool value) {
  member_resize_mode_ = value;
}

bool hasRestrictOwnAudio() const {
  return true;
}
bool restrictOwnAudio() const {
  return member_restrict_own_audio_;
}
void setRestrictOwnAudio(bool value) {
  member_restrict_own_audio_ = value;
}

bool hasSampleRate() const {
  return true;
}
bool sampleRate() const {
  return member_sample_rate_;
}
void setSampleRate(bool value) {
  member_sample_rate_ = value;
}

bool hasSampleSize() const {
  return true;
}
bool sampleSize() const {
  return member_sample_size_;
}
void setSampleSize(bool value) {
  member_sample_size_ = value;
}

bool hasSaturation() const {
  return true;
}
bool saturation() const {
  return member_saturation_;
}
void setSaturation(bool value) {
  member_saturation_ = value;
}

bool hasSharpness() const {
  return true;
}
bool sharpness() const {
  return member_sharpness_;
}
void setSharpness(bool value) {
  member_sharpness_ = value;
}

bool hasSuppressLocalAudioPlayback() const {
  return true;
}
bool suppressLocalAudioPlayback() const {
  return member_suppress_local_audio_playback_;
}
void setSuppressLocalAudioPlayback(bool value) {
  member_suppress_local_audio_playback_ = value;
}

bool hasTilt() const {
  return true;
}
bool tilt() const {
  return member_tilt_;
}
void setTilt(bool value) {
  member_tilt_ = value;
}

bool hasTorch() const {
  return true;
}
bool torch() const {
  return member_torch_;
}
void setTorch(bool value) {
  member_torch_ = value;
}

bool hasVoiceIsolation() const {
  return true;
}
bool voiceIsolation() const {
  return member_voice_isolation_;
}
void setVoiceIsolation(bool value) {
  member_voice_isolation_ = value;
}

bool hasWhiteBalanceMode() const {
  return true;
}
bool whiteBalanceMode() const {
  return member_white_balance_mode_;
}
void setWhiteBalanceMode(bool value) {
  member_white_balance_mode_ = value;
}

bool hasWidth() const {
  return true;
}
bool width() const {
  return member_width_;
}
void setWidth(bool value) {
  member_width_ = value;
}

bool hasZoom() const {
  return true;
}
bool zoom() const {
  return member_zoom_;
}
void setZoom(bool value) {
  member_zoom_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 40;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_aspect_ratio_{true};
bool member_auto_gain_control_{true};
bool member_background_blur_{true};
bool member_background_segmentation_mask_{true};
bool member_brightness_{true};
bool member_channel_count_{true};
bool member_color_temperature_{true};
bool member_contrast_{true};
bool member_device_id_{true};
bool member_display_surface_{true};
bool member_echo_cancellation_{true};
bool member_exposure_compensation_{true};
bool member_exposure_mode_{true};
bool member_exposure_time_{true};
bool member_eye_gaze_correction_{true};
bool member_face_framing_{true};
bool member_facing_mode_{true};
bool member_focus_distance_{true};
bool member_focus_mode_{true};
bool member_frame_rate_{true};
bool member_group_id_{true};
bool member_height_{true};
bool member_iso_{true};
bool member_latency_{true};
bool member_noise_suppression_{true};
bool member_pan_{true};
bool member_points_of_interest_{true};
bool member_resize_mode_{true};
bool member_restrict_own_audio_{true};
bool member_sample_rate_{true};
bool member_sample_size_{true};
bool member_saturation_{true};
bool member_sharpness_{true};
bool member_suppress_local_audio_playback_{true};
bool member_tilt_{true};
bool member_torch_{true};
bool member_voice_isolation_{true};
bool member_white_balance_mode_{true};
bool member_width_{true};
bool member_zoom_{true};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_SUPPORTED_CONSTRAINTS_H_
