// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_CONSTRAINTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_CONSTRAINTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_display_media_include_or_exclude.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_display_media_system_window_or_exclude.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CaptureController;
class ExceptionState;
class MediaTrackConstraints;
class V8UnionBooleanOrMediaTrackConstraints;

class MODULES_EXPORT MediaStreamConstraints : public bindings::InputDictionaryBase {
  
  public:
static MediaStreamConstraints* Create() {
  return MakeGarbageCollected<MediaStreamConstraints>();
}
static MediaStreamConstraints* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaStreamConstraints>(isolate);
}
static MediaStreamConstraints* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaStreamConstraints();
explicit  MediaStreamConstraints(v8::Isolate* isolate);

bool hasAudio() const {
  return true;
}
V8UnionBooleanOrMediaTrackConstraints* audio() const {
  return member_audio_.Get();
}
void setAudio(V8UnionBooleanOrMediaTrackConstraints* value) {
  member_audio_ = value;
DCHECK(member_audio_);
}

bool hasController() const {
  return has_controller_;
}
CaptureController* controller() const {
  DCHECK(hasController());
return member_controller_.Get();
}
CaptureController* getControllerOr(CaptureController* fallback_value) const {
  if (!hasController()) {
  return fallback_value;
}
return member_controller_.Get();
}
void setController(CaptureController* value) {
  member_controller_ = value;
has_controller_ = true;
DCHECK(member_controller_);
}

bool hasMonitorTypeSurfaces() const {
  return has_monitor_type_surfaces_;
}
V8DisplayMediaIncludeOrExclude monitorTypeSurfaces() const {
  DCHECK(hasMonitorTypeSurfaces());
return member_monitor_type_surfaces_;
}
V8DisplayMediaIncludeOrExclude getMonitorTypeSurfacesOr(V8DisplayMediaIncludeOrExclude fallback_value) const {
  if (!hasMonitorTypeSurfaces()) {
  return fallback_value;
}
return member_monitor_type_surfaces_;
}
void setMonitorTypeSurfaces(V8DisplayMediaIncludeOrExclude value) {
  member_monitor_type_surfaces_ = value;
has_monitor_type_surfaces_ = true;
}
void setMonitorTypeSurfaces(V8DisplayMediaIncludeOrExclude::Enum value) {
  member_monitor_type_surfaces_ = V8DisplayMediaIncludeOrExclude(value);
has_monitor_type_surfaces_ = true;
}

bool hasPreferCurrentTab() const {
  return true;
}
bool preferCurrentTab() const {
  return member_prefer_current_tab_;
}
void setPreferCurrentTab(bool value) {
  member_prefer_current_tab_ = value;
}

bool hasSelfBrowserSurface() const {
  return has_self_browser_surface_;
}
V8DisplayMediaIncludeOrExclude selfBrowserSurface() const {
  DCHECK(hasSelfBrowserSurface());
return member_self_browser_surface_;
}
V8DisplayMediaIncludeOrExclude getSelfBrowserSurfaceOr(V8DisplayMediaIncludeOrExclude fallback_value) const {
  if (!hasSelfBrowserSurface()) {
  return fallback_value;
}
return member_self_browser_surface_;
}
void setSelfBrowserSurface(V8DisplayMediaIncludeOrExclude value) {
  member_self_browser_surface_ = value;
has_self_browser_surface_ = true;
}
void setSelfBrowserSurface(V8DisplayMediaIncludeOrExclude::Enum value) {
  member_self_browser_surface_ = V8DisplayMediaIncludeOrExclude(value);
has_self_browser_surface_ = true;
}

bool hasSurfaceSwitching() const {
  return has_surface_switching_;
}
V8DisplayMediaIncludeOrExclude surfaceSwitching() const {
  DCHECK(hasSurfaceSwitching());
return member_surface_switching_;
}
V8DisplayMediaIncludeOrExclude getSurfaceSwitchingOr(V8DisplayMediaIncludeOrExclude fallback_value) const {
  if (!hasSurfaceSwitching()) {
  return fallback_value;
}
return member_surface_switching_;
}
void setSurfaceSwitching(V8DisplayMediaIncludeOrExclude value) {
  member_surface_switching_ = value;
has_surface_switching_ = true;
}
void setSurfaceSwitching(V8DisplayMediaIncludeOrExclude::Enum value) {
  member_surface_switching_ = V8DisplayMediaIncludeOrExclude(value);
has_surface_switching_ = true;
}

bool hasSystemAudio() const {
  return has_system_audio_;
}
V8DisplayMediaIncludeOrExclude systemAudio() const {
  DCHECK(hasSystemAudio());
return member_system_audio_;
}
V8DisplayMediaIncludeOrExclude getSystemAudioOr(V8DisplayMediaIncludeOrExclude fallback_value) const {
  if (!hasSystemAudio()) {
  return fallback_value;
}
return member_system_audio_;
}
void setSystemAudio(V8DisplayMediaIncludeOrExclude value) {
  member_system_audio_ = value;
has_system_audio_ = true;
}
void setSystemAudio(V8DisplayMediaIncludeOrExclude::Enum value) {
  member_system_audio_ = V8DisplayMediaIncludeOrExclude(value);
has_system_audio_ = true;
}

bool hasVideo() const {
  return true;
}
V8UnionBooleanOrMediaTrackConstraints* video() const {
  return member_video_.Get();
}
void setVideo(V8UnionBooleanOrMediaTrackConstraints* value) {
  member_video_ = value;
DCHECK(member_video_);
}

bool hasWindowAudio() const {
  return has_window_audio_;
}
V8DisplayMediaSystemWindowOrExclude windowAudio() const {
  DCHECK(hasWindowAudio());
return member_window_audio_;
}
V8DisplayMediaSystemWindowOrExclude getWindowAudioOr(V8DisplayMediaSystemWindowOrExclude fallback_value) const {
  if (!hasWindowAudio()) {
  return fallback_value;
}
return member_window_audio_;
}
void setWindowAudio(V8DisplayMediaSystemWindowOrExclude value) {
  member_window_audio_ = value;
has_window_audio_ = true;
}
void setWindowAudio(V8DisplayMediaSystemWindowOrExclude::Enum value) {
  member_window_audio_ = V8DisplayMediaSystemWindowOrExclude(value);
has_window_audio_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_controller_ = false;
bool has_monitor_type_surfaces_ = false;
bool has_self_browser_surface_ = false;
bool has_surface_switching_ = false;
bool has_system_audio_ = false;
bool has_window_audio_ = false;

Member<V8UnionBooleanOrMediaTrackConstraints> member_audio_;
Member<CaptureController> member_controller_;
V8DisplayMediaIncludeOrExclude member_monitor_type_surfaces_{static_cast<V8DisplayMediaIncludeOrExclude::Enum>(0)};
bool member_prefer_current_tab_{false};
V8DisplayMediaIncludeOrExclude member_self_browser_surface_{static_cast<V8DisplayMediaIncludeOrExclude::Enum>(0)};
V8DisplayMediaIncludeOrExclude member_surface_switching_{static_cast<V8DisplayMediaIncludeOrExclude::Enum>(0)};
V8DisplayMediaIncludeOrExclude member_system_audio_{static_cast<V8DisplayMediaIncludeOrExclude::Enum>(0)};
Member<V8UnionBooleanOrMediaTrackConstraints> member_video_;
V8DisplayMediaSystemWindowOrExclude member_window_audio_{static_cast<V8DisplayMediaSystemWindowOrExclude::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_CONSTRAINTS_H_
