// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_media_key_system_configuration.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_key_system_media_capability.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"audioCapabilities",
"distinctiveIdentifier",
"initDataTypes",
"label",
"persistentState",
"sessionTypes",
"videoCapabilities",
};


}  // namespace 

MediaKeySystemConfiguration* MediaKeySystemConfiguration::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MediaKeySystemConfiguration* dictionary = MakeGarbageCollected<MediaKeySystemConfiguration>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MediaKeySystemConfiguration";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MediaKeySystemConfiguration::MediaKeySystemConfiguration() {
  
}

 MediaKeySystemConfiguration::MediaKeySystemConfiguration(v8::Isolate* isolate) {
  
}



void MediaKeySystemConfiguration::setAudioCapabilities(const HeapVector<Member<MediaKeySystemMediaCapability>>& value) {
  member_audio_capabilities_ = value;
}

void MediaKeySystemConfiguration::setAudioCapabilities(HeapVector<Member<MediaKeySystemMediaCapability>>&& value) {
  member_audio_capabilities_ = std::move(value);
}









void MediaKeySystemConfiguration::setInitDataTypes(const Vector<String>& value) {
  member_init_data_types_ = value;
}

void MediaKeySystemConfiguration::setInitDataTypes(Vector<String>&& value) {
  member_init_data_types_ = std::move(value);
}




void MediaKeySystemConfiguration::setLabel(const String& value) {
  member_label_ = value;
}

void MediaKeySystemConfiguration::setLabel(String&& value) {
  member_label_ = std::move(value);
}









Vector<String> MediaKeySystemConfiguration::getSessionTypesOr(const Vector<String>& fallback_value) const {
  if (!hasSessionTypes()) {
  return fallback_value;
}
return member_session_types_;
}

Vector<String> MediaKeySystemConfiguration::getSessionTypesOr(Vector<String>&& fallback_value) const {
  if (!hasSessionTypes()) {
  return std::move(fallback_value);
}
return member_session_types_;
}

void MediaKeySystemConfiguration::setSessionTypes(const Vector<String>& value) {
  member_session_types_ = value;
has_session_types_ = true;
}

void MediaKeySystemConfiguration::setSessionTypes(Vector<String>&& value) {
  member_session_types_ = std::move(value);
has_session_types_ = true;
}




void MediaKeySystemConfiguration::setVideoCapabilities(const HeapVector<Member<MediaKeySystemMediaCapability>>& value) {
  member_video_capabilities_ = value;
}

void MediaKeySystemConfiguration::setVideoCapabilities(HeapVector<Member<MediaKeySystemMediaCapability>>&& value) {
  member_video_capabilities_ = std::move(value);
}



void MediaKeySystemConfiguration::Trace(Visitor* visitor) const {
  visitor->Trace(member_audio_capabilities_);
visitor->Trace(member_video_capabilities_);
bindings::DictionaryBase::Trace(visitor);
}

void MediaKeySystemConfiguration::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MediaKeySystemConfiguration::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAudioCapabilities()) {
  values[0] = ToV8Traits<IDLSequence<MediaKeySystemMediaCapability>>::ToV8(script_state, member_audio_capabilities_);
DCHECK(!values[0].IsEmpty());
}
if (hasDistinctiveIdentifier()) {
  values[1] = ToV8Traits<V8MediaKeysRequirement>::ToV8(script_state, member_distinctive_identifier_);
DCHECK(!values[1].IsEmpty());
}
if (hasInitDataTypes()) {
  values[2] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_init_data_types_);
DCHECK(!values[2].IsEmpty());
}
if (hasLabel()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_label_);
DCHECK(!values[3].IsEmpty());
}
if (hasPersistentState()) {
  values[4] = ToV8Traits<V8MediaKeysRequirement>::ToV8(script_state, member_persistent_state_);
DCHECK(!values[4].IsEmpty());
}
if (hasSessionTypes()) {
  values[5] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_session_types_);
DCHECK(!values[5].IsEmpty());
}
if (hasVideoCapabilities()) {
  values[6] = ToV8Traits<IDLSequence<MediaKeySystemMediaCapability>>::ToV8(script_state, member_video_capabilities_);
DCHECK(!values[6].IsEmpty());
}
}

const void* MediaKeySystemConfiguration::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MediaKeySystemConfiguration::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MediaKeySystemConfiguration::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MediaKeySystemConfiguration";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("audioCapabilities");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<MediaKeySystemMediaCapability>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_audio_capabilities_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("distinctiveIdentifier");
if (!bindings::GetDictionaryMemberFromV8Object<V8MediaKeysRequirement, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_distinctive_identifier_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("initDataTypes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_init_data_types_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("label");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_label_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("persistentState");
if (!bindings::GetDictionaryMemberFromV8Object<V8MediaKeysRequirement, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_persistent_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sessionTypes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_session_types_, member_session_types_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("videoCapabilities");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<MediaKeySystemMediaCapability>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_video_capabilities_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MediaKeySystemConfiguration::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
