// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_DECODING_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_DECODING_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_configuration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_decoding_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaCapabilitiesKeySystemConfiguration;

class MODULES_EXPORT MediaDecodingConfiguration : public MediaConfiguration {
  
  public:
static MediaDecodingConfiguration* Create() {
  return MakeGarbageCollected<MediaDecodingConfiguration>();
}
static MediaDecodingConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaDecodingConfiguration>(isolate);
}
static MediaDecodingConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaDecodingConfiguration();
explicit  MediaDecodingConfiguration(v8::Isolate* isolate);

bool hasKeySystemConfiguration() const {
  return has_key_system_configuration_;
}
MediaCapabilitiesKeySystemConfiguration* keySystemConfiguration() const {
  DCHECK(hasKeySystemConfiguration());
return member_key_system_configuration_.Get();
}
MediaCapabilitiesKeySystemConfiguration* getKeySystemConfigurationOr(MediaCapabilitiesKeySystemConfiguration* fallback_value) const {
  if (!hasKeySystemConfiguration()) {
  return fallback_value;
}
return member_key_system_configuration_.Get();
}
void setKeySystemConfiguration(MediaCapabilitiesKeySystemConfiguration* value) {
  member_key_system_configuration_ = value;
has_key_system_configuration_ = true;
DCHECK(member_key_system_configuration_);
}

bool hasType() const {
  return true;
}
V8MediaDecodingType type() const {
  return member_type_;
}
void setType(V8MediaDecodingType value) {
  member_type_ = value;
}
void setType(V8MediaDecodingType::Enum value) {
  member_type_ = V8MediaDecodingType(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MediaConfiguration::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_key_system_configuration_ = false;

Member<MediaCapabilitiesKeySystemConfiguration> member_key_system_configuration_;
V8MediaDecodingType member_type_{static_cast<V8MediaDecodingType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_DECODING_CONFIGURATION_H_
