// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LONG_RANGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LONG_RANGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT LongRange : public bindings::DictionaryBase {
  
  public:
static LongRange* Create() {
  return MakeGarbageCollected<LongRange>();
}
static LongRange* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LongRange>(isolate);
}
static LongRange* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LongRange();
explicit  LongRange(v8::Isolate* isolate);

bool hasMax() const {
  return has_max_;
}
int32_t max() const {
  DCHECK(hasMax());
return member_max_;
}
int32_t getMaxOr(int32_t fallback_value) const {
  if (!hasMax()) {
  return fallback_value;
}
return member_max_;
}
void setMax(int32_t value) {
  member_max_ = value;
has_max_ = true;
}

bool hasMin() const {
  return has_min_;
}
int32_t min() const {
  DCHECK(hasMin());
return member_min_;
}
int32_t getMinOr(int32_t fallback_value) const {
  if (!hasMin()) {
  return fallback_value;
}
return member_min_;
}
void setMin(int32_t value) {
  member_min_ = value;
has_min_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_max_ = false;
bool has_min_ = false;

int32_t member_max_;
int32_t member_min_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LONG_RANGE_H_
