// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOGIN_STATUS_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOGIN_STATUS_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class IdentityProviderAccount;

class MODULES_EXPORT LoginStatusOptions : public bindings::InputDictionaryBase {
  
  public:
static LoginStatusOptions* Create() {
  return MakeGarbageCollected<LoginStatusOptions>();
}
static LoginStatusOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LoginStatusOptions>(isolate);
}
static LoginStatusOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LoginStatusOptions();
explicit  LoginStatusOptions(v8::Isolate* isolate);

bool hasAccounts() const {
  return has_accounts_;
}
const HeapVector<Member<IdentityProviderAccount>>& accounts() const {
  DCHECK(hasAccounts());
return member_accounts_;
}
HeapVector<Member<IdentityProviderAccount>> getAccountsOr(const HeapVector<Member<IdentityProviderAccount>>& fallback_value) const;
HeapVector<Member<IdentityProviderAccount>> getAccountsOr(HeapVector<Member<IdentityProviderAccount>>&& fallback_value) const;
void setAccounts(const HeapVector<Member<IdentityProviderAccount>>& value);
void setAccounts(HeapVector<Member<IdentityProviderAccount>>&& value);

bool hasExpiration() const {
  return has_expiration_;
}
uint64_t expiration() const {
  DCHECK(hasExpiration());
return member_expiration_;
}
uint64_t getExpirationOr(uint64_t fallback_value) const {
  if (!hasExpiration()) {
  return fallback_value;
}
return member_expiration_;
}
void setExpiration(uint64_t value) {
  member_expiration_ = value;
has_expiration_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_accounts_ = false;
bool has_expiration_ = false;

HeapVector<Member<IdentityProviderAccount>> member_accounts_;
uint64_t member_expiration_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOGIN_STATUS_OPTIONS_H_
