// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOCK_MANAGER_SNAPSHOT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOCK_MANAGER_SNAPSHOT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class LockInfo;

class MODULES_EXPORT LockManagerSnapshot : public bindings::DictionaryBase {
  
  public:
static LockManagerSnapshot* Create() {
  return MakeGarbageCollected<LockManagerSnapshot>();
}
static LockManagerSnapshot* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LockManagerSnapshot>(isolate);
}
static LockManagerSnapshot* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LockManagerSnapshot();
explicit  LockManagerSnapshot(v8::Isolate* isolate);

bool hasHeld() const {
  return has_held_;
}
const HeapVector<Member<LockInfo>>& held() const {
  DCHECK(hasHeld());
return member_held_;
}
HeapVector<Member<LockInfo>> getHeldOr(const HeapVector<Member<LockInfo>>& fallback_value) const;
HeapVector<Member<LockInfo>> getHeldOr(HeapVector<Member<LockInfo>>&& fallback_value) const;
void setHeld(const HeapVector<Member<LockInfo>>& value);
void setHeld(HeapVector<Member<LockInfo>>&& value);

bool hasPending() const {
  return has_pending_;
}
const HeapVector<Member<LockInfo>>& pending() const {
  DCHECK(hasPending());
return member_pending_;
}
HeapVector<Member<LockInfo>> getPendingOr(const HeapVector<Member<LockInfo>>& fallback_value) const;
HeapVector<Member<LockInfo>> getPendingOr(HeapVector<Member<LockInfo>>&& fallback_value) const;
void setPending(const HeapVector<Member<LockInfo>>& value);
void setPending(HeapVector<Member<LockInfo>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_held_ = false;
bool has_pending_ = false;

HeapVector<Member<LockInfo>> member_held_;
HeapVector<Member<LockInfo>> member_pending_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOCK_MANAGER_SNAPSHOT_H_
