// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOCK_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOCK_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT LockInfo : public bindings::DictionaryBase {
  
  public:
static LockInfo* Create() {
  return MakeGarbageCollected<LockInfo>();
}
static LockInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LockInfo>(isolate);
}
static LockInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LockInfo();
explicit  LockInfo(v8::Isolate* isolate);

bool hasClientId() const {
  return has_client_id_;
}
const String& clientId() const {
  DCHECK(hasClientId());
return member_client_id_;
}
String getClientIdOr(const String& fallback_value) const;
String getClientIdOr(String&& fallback_value) const;
void setClientId(const String& value);
void setClientId(String&& value);

bool hasMode() const {
  return has_mode_;
}
V8LockMode mode() const {
  DCHECK(hasMode());
return member_mode_;
}
V8LockMode getModeOr(V8LockMode fallback_value) const {
  if (!hasMode()) {
  return fallback_value;
}
return member_mode_;
}
void setMode(V8LockMode value) {
  member_mode_ = value;
has_mode_ = true;
}
void setMode(V8LockMode::Enum value) {
  member_mode_ = V8LockMode(value);
has_mode_ = true;
}

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_client_id_ = false;
bool has_mode_ = false;
bool has_name_ = false;

String member_client_id_;
V8LockMode member_mode_{static_cast<V8LockMode::Enum>(0)};
String member_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LOCK_INFO_H_
