// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_create_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_create_monitor_callback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_message.h"
#include "third_party/blink/renderer/core/dom/abort_signal.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"initialPrompts",
"monitor",
"signal",
};


}  // namespace 

LanguageModelCreateOptions* LanguageModelCreateOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  LanguageModelCreateOptions* dictionary = MakeGarbageCollected<LanguageModelCreateOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "LanguageModelCreateOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 LanguageModelCreateOptions::LanguageModelCreateOptions() {
  
}

 LanguageModelCreateOptions::LanguageModelCreateOptions(v8::Isolate* isolate) : LanguageModelCreateCoreOptions(isolate) {
  
}



HeapVector<Member<LanguageModelMessage>> LanguageModelCreateOptions::getInitialPromptsOr(const HeapVector<Member<LanguageModelMessage>>& fallback_value) const {
  if (!hasInitialPrompts()) {
  return fallback_value;
}
return member_initial_prompts_;
}

HeapVector<Member<LanguageModelMessage>> LanguageModelCreateOptions::getInitialPromptsOr(HeapVector<Member<LanguageModelMessage>>&& fallback_value) const {
  if (!hasInitialPrompts()) {
  return std::move(fallback_value);
}
return member_initial_prompts_;
}

void LanguageModelCreateOptions::setInitialPrompts(const HeapVector<Member<LanguageModelMessage>>& value) {
  member_initial_prompts_ = value;
has_initial_prompts_ = true;
}

void LanguageModelCreateOptions::setInitialPrompts(HeapVector<Member<LanguageModelMessage>>&& value) {
  member_initial_prompts_ = std::move(value);
has_initial_prompts_ = true;
}

















void LanguageModelCreateOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_initial_prompts_);
visitor->Trace(member_monitor_);
visitor->Trace(member_signal_);
LanguageModelCreateCoreOptions::Trace(visitor);
}

void LanguageModelCreateOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
LanguageModelCreateCoreOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "LanguageModelCreateOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("initialPrompts");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<LanguageModelMessage>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_initial_prompts_, member_initial_prompts_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("monitor");
if (!bindings::GetDictionaryMemberFromV8Object<V8CreateMonitorCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_monitor_, member_monitor_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<AbortSignal, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_signal_, member_signal_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> LanguageModelCreateOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
