// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_image_resource.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"platform",
"purpose",
"sizes",
"src",
"type",
};


}  // namespace 

ManifestImageResource* ManifestImageResource::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ManifestImageResource* dictionary = MakeGarbageCollected<ManifestImageResource>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ImageResource";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ManifestImageResource::ManifestImageResource() {
  
}

 ManifestImageResource::ManifestImageResource(v8::Isolate* isolate) {
  
}



String ManifestImageResource::getPlatformOr(const String& fallback_value) const {
  if (!hasPlatform()) {
  return fallback_value;
}
return member_platform_;
}

String ManifestImageResource::getPlatformOr(String&& fallback_value) const {
  if (!hasPlatform()) {
  return std::move(fallback_value);
}
return member_platform_;
}

void ManifestImageResource::setPlatform(const String& value) {
  member_platform_ = value;
has_platform_ = true;
}

void ManifestImageResource::setPlatform(String&& value) {
  member_platform_ = std::move(value);
has_platform_ = true;
}




String ManifestImageResource::getPurposeOr(const String& fallback_value) const {
  if (!hasPurpose()) {
  return fallback_value;
}
return member_purpose_;
}

String ManifestImageResource::getPurposeOr(String&& fallback_value) const {
  if (!hasPurpose()) {
  return std::move(fallback_value);
}
return member_purpose_;
}

void ManifestImageResource::setPurpose(const String& value) {
  member_purpose_ = value;
has_purpose_ = true;
}

void ManifestImageResource::setPurpose(String&& value) {
  member_purpose_ = std::move(value);
has_purpose_ = true;
}




String ManifestImageResource::getSizesOr(const String& fallback_value) const {
  if (!hasSizes()) {
  return fallback_value;
}
return member_sizes_;
}

String ManifestImageResource::getSizesOr(String&& fallback_value) const {
  if (!hasSizes()) {
  return std::move(fallback_value);
}
return member_sizes_;
}

void ManifestImageResource::setSizes(const String& value) {
  member_sizes_ = value;
has_sizes_ = true;
}

void ManifestImageResource::setSizes(String&& value) {
  member_sizes_ = std::move(value);
has_sizes_ = true;
}




void ManifestImageResource::setSrc(const String& value) {
  member_src_ = value;
}

void ManifestImageResource::setSrc(String&& value) {
  member_src_ = std::move(value);
}




String ManifestImageResource::getTypeOr(const String& fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}

String ManifestImageResource::getTypeOr(String&& fallback_value) const {
  if (!hasType()) {
  return std::move(fallback_value);
}
return member_type_;
}

void ManifestImageResource::setType(const String& value) {
  member_type_ = value;
has_type_ = true;
}

void ManifestImageResource::setType(String&& value) {
  member_type_ = std::move(value);
has_type_ = true;
}



void ManifestImageResource::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void ManifestImageResource::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ImageResource";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("platform");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_platform_, member_platform_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("purpose");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_purpose_, member_purpose_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sizes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_sizes_, member_sizes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("src");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_src_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ManifestImageResource::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
