// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IIR_FILTER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IIR_FILTER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IIRFilterOptions : public AudioNodeOptions {
  
  public:
static IIRFilterOptions* Create() {
  return MakeGarbageCollected<IIRFilterOptions>();
}
static IIRFilterOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IIRFilterOptions>(isolate);
}
static IIRFilterOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IIRFilterOptions();
explicit  IIRFilterOptions(v8::Isolate* isolate);

bool hasFeedback() const {
  return true;
}
const Vector<double>& feedback() const {
  return member_feedback_;
}
void setFeedback(const Vector<double>& value);
void setFeedback(Vector<double>&& value);

bool hasFeedforward() const {
  return true;
}
const Vector<double>& feedforward() const {
  return member_feedforward_;
}
void setFeedforward(const Vector<double>& value);
void setFeedforward(Vector<double>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Vector<double> member_feedback_;
Vector<double> member_feedforward_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IIR_FILTER_OPTIONS_H_
