// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_CREDENTIAL_ERROR_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_CREDENTIAL_ERROR_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IdentityCredentialErrorInit : public bindings::InputDictionaryBase {
  
  public:
static IdentityCredentialErrorInit* Create() {
  return MakeGarbageCollected<IdentityCredentialErrorInit>();
}
static IdentityCredentialErrorInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IdentityCredentialErrorInit>(isolate);
}
static IdentityCredentialErrorInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IdentityCredentialErrorInit();
explicit  IdentityCredentialErrorInit(v8::Isolate* isolate);

bool hasCode() const {
  return has_code_;
}
const String& code() const {
  DCHECK(hasCode());
return member_code_;
}
String getCodeOr(const String& fallback_value) const;
String getCodeOr(String&& fallback_value) const;
void setCode(const String& value);
void setCode(String&& value);

bool hasError() const {
  return has_error_;
}
const String& error() const {
  DCHECK(hasError());
return member_error_;
}
String getErrorOr(const String& fallback_value) const;
String getErrorOr(String&& fallback_value) const;
void setError(const String& value);
void setError(String&& value);

bool hasUrl() const {
  return has_url_;
}
const String& url() const {
  DCHECK(hasUrl());
return member_url_;
}
String getUrlOr(const String& fallback_value) const;
String getUrlOr(String&& fallback_value) const;
void setUrl(const String& value);
void setUrl(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_code_ = false;
bool has_error_ = false;
bool has_url_ = false;

String member_code_;
String member_error_;
String member_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDENTITY_CREDENTIAL_ERROR_INIT_H_
