// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_BUFFER_LAYOUT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_BUFFER_LAYOUT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_vertex_step_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUVertexAttribute;

class MODULES_EXPORT GPUVertexBufferLayout : public bindings::InputDictionaryBase {
  
  public:
static GPUVertexBufferLayout* Create() {
  return MakeGarbageCollected<GPUVertexBufferLayout>();
}
static GPUVertexBufferLayout* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUVertexBufferLayout>(isolate);
}
static GPUVertexBufferLayout* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUVertexBufferLayout();
explicit  GPUVertexBufferLayout(v8::Isolate* isolate);

bool hasArrayStride() const {
  return true;
}
uint64_t arrayStride() const {
  return member_array_stride_;
}
void setArrayStride(uint64_t value) {
  member_array_stride_ = value;
}

bool hasAttributes() const {
  return true;
}
const HeapVector<Member<GPUVertexAttribute>>& attributes() const {
  return member_attributes_;
}
void setAttributes(const HeapVector<Member<GPUVertexAttribute>>& value);
void setAttributes(HeapVector<Member<GPUVertexAttribute>>&& value);

bool hasStepMode() const {
  return true;
}
V8GPUVertexStepMode stepMode() const {
  return member_step_mode_;
}
void setStepMode(V8GPUVertexStepMode value) {
  member_step_mode_ = value;
}
void setStepMode(V8GPUVertexStepMode::Enum value) {
  member_step_mode_ = V8GPUVertexStepMode(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint64_t member_array_stride_;
HeapVector<Member<GPUVertexAttribute>> member_attributes_;
V8GPUVertexStepMode member_step_mode_{V8GPUVertexStepMode::Enum::kVertex};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_BUFFER_LAYOUT_H_
