// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_EXTENT_3D_DICT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_EXTENT_3D_DICT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUExtent3DDict : public bindings::InputDictionaryBase {
  
  public:
static GPUExtent3DDict* Create() {
  return MakeGarbageCollected<GPUExtent3DDict>();
}
static GPUExtent3DDict* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUExtent3DDict>(isolate);
}
static GPUExtent3DDict* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUExtent3DDict();
explicit  GPUExtent3DDict(v8::Isolate* isolate);

bool hasDepth() const {
  return !member_depth_.IsEmpty();
}
const ScriptValue& depth() const {
  DCHECK(hasDepth());
return member_depth_;
}
ScriptValue getDepthOr(const ScriptValue& fallback_value) const {
  if (!hasDepth()) {
  return fallback_value;
}
return member_depth_;
}
void setDepth(const ScriptValue& value) {
  member_depth_ = value;
}

bool hasDepthOrArrayLayers() const {
  return true;
}
uint32_t depthOrArrayLayers() const {
  return member_depth_or_array_layers_;
}
void setDepthOrArrayLayers(uint32_t value) {
  member_depth_or_array_layers_ = value;
}

bool hasHeight() const {
  return true;
}
uint32_t height() const {
  return member_height_;
}
void setHeight(uint32_t value) {
  member_height_ = value;
}

bool hasWidth() const {
  return true;
}
uint32_t width() const {
  return member_width_;
}
void setWidth(uint32_t value) {
  member_width_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



ScriptValue member_depth_;
uint32_t member_depth_or_array_layers_{1};
uint32_t member_height_{1};
uint32_t member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_EXTENT_3D_DICT_H_
