// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BLEND_COMPONENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BLEND_COMPONENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_blend_factor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_blend_operation.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUBlendComponent : public bindings::DictionaryBase {
  
  public:
static GPUBlendComponent* Create() {
  return MakeGarbageCollected<GPUBlendComponent>();
}
static GPUBlendComponent* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBlendComponent>(isolate);
}
static GPUBlendComponent* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBlendComponent();
explicit  GPUBlendComponent(v8::Isolate* isolate);

bool hasDstFactor() const {
  return has_dst_factor_;
}
V8GPUBlendFactor dstFactor() const {
  DCHECK(hasDstFactor());
return member_dst_factor_;
}
V8GPUBlendFactor getDstFactorOr(V8GPUBlendFactor fallback_value) const {
  if (!hasDstFactor()) {
  return fallback_value;
}
return member_dst_factor_;
}
void setDstFactor(V8GPUBlendFactor value) {
  member_dst_factor_ = value;
has_dst_factor_ = true;
}
void setDstFactor(V8GPUBlendFactor::Enum value) {
  member_dst_factor_ = V8GPUBlendFactor(value);
has_dst_factor_ = true;
}

bool hasOperation() const {
  return has_operation_;
}
V8GPUBlendOperation operation() const {
  DCHECK(hasOperation());
return member_operation_;
}
V8GPUBlendOperation getOperationOr(V8GPUBlendOperation fallback_value) const {
  if (!hasOperation()) {
  return fallback_value;
}
return member_operation_;
}
void setOperation(V8GPUBlendOperation value) {
  member_operation_ = value;
has_operation_ = true;
}
void setOperation(V8GPUBlendOperation::Enum value) {
  member_operation_ = V8GPUBlendOperation(value);
has_operation_ = true;
}

bool hasSrcFactor() const {
  return has_src_factor_;
}
V8GPUBlendFactor srcFactor() const {
  DCHECK(hasSrcFactor());
return member_src_factor_;
}
V8GPUBlendFactor getSrcFactorOr(V8GPUBlendFactor fallback_value) const {
  if (!hasSrcFactor()) {
  return fallback_value;
}
return member_src_factor_;
}
void setSrcFactor(V8GPUBlendFactor value) {
  member_src_factor_ = value;
has_src_factor_ = true;
}
void setSrcFactor(V8GPUBlendFactor::Enum value) {
  member_src_factor_ = V8GPUBlendFactor(value);
has_src_factor_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dst_factor_ = false;
bool has_operation_ = false;
bool has_src_factor_ = false;

V8GPUBlendFactor member_dst_factor_{static_cast<V8GPUBlendFactor::Enum>(0)};
V8GPUBlendOperation member_operation_{static_cast<V8GPUBlendOperation::Enum>(0)};
V8GPUBlendFactor member_src_factor_{static_cast<V8GPUBlendFactor::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BLEND_COMPONENT_H_
