// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group_layout_entry.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer_binding_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_external_texture_binding_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler_binding_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_storage_texture_binding_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_binding_layout.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"binding",
"bindingArraySize",
"buffer",
"externalTexture",
"sampler",
"storageTexture",
"texture",
"visibility",
};


}  // namespace 

GPUBindGroupLayoutEntry* GPUBindGroupLayoutEntry::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUBindGroupLayoutEntry* dictionary = MakeGarbageCollected<GPUBindGroupLayoutEntry>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUBindGroupLayoutEntry";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUBindGroupLayoutEntry::GPUBindGroupLayoutEntry() {
  
}

 GPUBindGroupLayoutEntry::GPUBindGroupLayoutEntry(v8::Isolate* isolate) {
  
}




















































void GPUBindGroupLayoutEntry::Trace(Visitor* visitor) const {
  visitor->Trace(member_buffer_);
visitor->Trace(member_external_texture_);
visitor->Trace(member_sampler_);
visitor->Trace(member_storage_texture_);
visitor->Trace(member_texture_);
bindings::InputDictionaryBase::Trace(visitor);
}

void GPUBindGroupLayoutEntry::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "GPUBindGroupLayoutEntry";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("binding");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_binding_, class_like_name, exception_state)) {
  return;
}
constexpr bool is_optional = false;
if (RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("bindingArraySize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_binding_array_size_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("buffer");
if (!bindings::GetDictionaryMemberFromV8Object<GPUBufferBindingLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_buffer_, member_buffer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("externalTexture");
if (!bindings::GetDictionaryMemberFromV8Object<GPUExternalTextureBindingLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_external_texture_, member_external_texture_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampler");
if (!bindings::GetDictionaryMemberFromV8Object<GPUSamplerBindingLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_sampler_, member_sampler_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("storageTexture");
if (!bindings::GetDictionaryMemberFromV8Object<GPUStorageTextureBindingLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_storage_texture_, member_storage_texture_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("texture");
if (!bindings::GetDictionaryMemberFromV8Object<GPUTextureBindingLayout, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_texture_, member_texture_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("visibility");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_visibility_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUBindGroupLayoutEntry::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
