// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_file_picker_accept_type.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_usvstring_usvstringsequence.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"accept",
"description",
};


}  // namespace 

FilePickerAcceptType* FilePickerAcceptType::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  FilePickerAcceptType* dictionary = MakeGarbageCollected<FilePickerAcceptType>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "FilePickerAcceptType";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 FilePickerAcceptType::FilePickerAcceptType() {
  
}

 FilePickerAcceptType::FilePickerAcceptType(v8::Isolate* isolate) {
  
}



HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>> FilePickerAcceptType::getAcceptOr(const HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>& fallback_value) const {
  if (!hasAccept()) {
  return fallback_value;
}
return member_accept_;
}

HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>> FilePickerAcceptType::getAcceptOr(HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>&& fallback_value) const {
  if (!hasAccept()) {
  return std::move(fallback_value);
}
return member_accept_;
}

void FilePickerAcceptType::setAccept(const HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>& value) {
  member_accept_ = value;
has_accept_ = true;
}

void FilePickerAcceptType::setAccept(HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>&& value) {
  member_accept_ = std::move(value);
has_accept_ = true;
}




void FilePickerAcceptType::setDescription(const String& value) {
  member_description_ = value;
}

void FilePickerAcceptType::setDescription(String&& value) {
  member_description_ = std::move(value);
}



void FilePickerAcceptType::Trace(Visitor* visitor) const {
  visitor->Trace(member_accept_);
bindings::InputDictionaryBase::Trace(visitor);
}

void FilePickerAcceptType::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "FilePickerAcceptType";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("accept");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, V8UnionUSVStringOrUSVStringSequence>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_accept_, member_accept_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("description");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_description_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> FilePickerAcceptType::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
