// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_rendering_context_2d_settings.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_tone_mapping.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"alpha",
"colorSpace",
"colorType",
"desynchronized",
"toneMapping",
"willReadFrequently",
};


}  // namespace 

CanvasRenderingContext2DSettings* CanvasRenderingContext2DSettings::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CanvasRenderingContext2DSettings* dictionary = MakeGarbageCollected<CanvasRenderingContext2DSettings>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  // [PermissiveDictionaryConversion]
return dictionary;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CanvasRenderingContext2DSettings::CanvasRenderingContext2DSettings() : member_tone_mapping_(CanvasToneMapping::Create()) {
  
}

 CanvasRenderingContext2DSettings::CanvasRenderingContext2DSettings(v8::Isolate* isolate) : member_tone_mapping_(CanvasToneMapping::Create()) {
  
}
































void CanvasRenderingContext2DSettings::Trace(Visitor* visitor) const {
  visitor->Trace(member_tone_mapping_);
bindings::DictionaryBase::Trace(visitor);
}

void CanvasRenderingContext2DSettings::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void CanvasRenderingContext2DSettings::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAlpha()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_alpha_);
DCHECK(!values[0].IsEmpty());
}
if (hasColorSpace()) {
  values[1] = ToV8Traits<V8PredefinedColorSpace>::ToV8(script_state, member_color_space_);
DCHECK(!values[1].IsEmpty());
}
if (RuntimeEnabledFeatures::CanvasFloatingPointEnabled()) {
  if (hasColorType()) {
  values[2] = ToV8Traits<V8CanvasPixelFormat>::ToV8(script_state, member_color_type_);
DCHECK(!values[2].IsEmpty());
}
}
if (hasDesynchronized()) {
  values[3] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_desynchronized_);
DCHECK(!values[3].IsEmpty());
}
if (hasToneMapping()) {
  values[4] = ToV8Traits<CanvasToneMapping>::ToV8(script_state, member_tone_mapping_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasWillReadFrequently()) {
  values[5] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_will_read_frequently_);
DCHECK(!values[5].IsEmpty());
}
}

const void* CanvasRenderingContext2DSettings::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> CanvasRenderingContext2DSettings::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void CanvasRenderingContext2DSettings::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CanvasRenderingContext2DSettings";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("alpha");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_alpha_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorSpace");
if (!bindings::GetDictionaryMemberFromV8Object<V8PredefinedColorSpace, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_color_space_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::CanvasFloatingPointEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("colorType");
if (!bindings::GetDictionaryMemberFromV8Object<V8CanvasPixelFormat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_color_type_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("desynchronized");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_desynchronized_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("toneMapping");
if (!bindings::GetDictionaryMemberFromV8Object<CanvasToneMapping, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_tone_mapping_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("willReadFrequently");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_will_read_frequently_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CanvasRenderingContext2DSettings::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
